/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill.mage.chainlightning;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.skill.Skill;
import com.hwijinrpg.skill.SkillTracker;
import com.hwijinrpg.skill.mage.chainlightning.ChainLightningDto;
import com.hwijinrpg.skill.mage.chainlightning.ChainLightningSkillContext;
import com.hwijinrpg.util.DamageUtil;
import com.hwijinrpg.util.RayCastUtil;
import com.hwijinrpg.util.VectorUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class ChainLightningTracker
extends SkillTracker {
    private static final Map<UUID, ChainLightningDto> ticks = new HashMap<UUID, ChainLightningDto>();
    private static final Random random = new Random(System.currentTimeMillis());

    public static void start(class_3222 player) {
        ChainLightningDto dto = new ChainLightningDto();
        dto.addDamaged((class_1309)player);
        ticks.put(player.method_5667(), dto);
    }

    public static void tick(class_1937 world, class_3222 player, PlayerRpgComponent comp) {
        ChainLightningSkillContext context = (ChainLightningSkillContext)SkillContextsByLevelConfig.getInstance().getSkillContext(Skill.CHAIN_LIGHTNING, comp.getSkills().get(Skill.CHAIN_LIGHTNING), new TypeToken<ChainLightningSkillContext>(){}.getType());
        ChainLightningDto dto = ticks.get(player.method_5667());
        if (dto == null || context == null) {
            return;
        }
        if (dto.getTickPassed() == 2) {
            dto.initCenterAndDirection(player);
        }
        if (dto.getTickPassed() >= 2 && dto.getTickPassed() % 4 == 2) {
            if (dto.getCurrentChainCount() == 0) {
                class_1309 entityRayCastResult = RayCastUtil.rayCastEntity(world, dto.getCenter(), dto.getDirection(), context.getMaxDistance(), 1.5);
                if (entityRayCastResult == null) {
                    class_239 blockResult = RayCastUtil.rayCastBlock(world, player, dto.getCenter(), dto.getDirection(), context.getMaxDistance());
                    if (blockResult.method_17783() == class_239.class_240.field_1333) {
                        ChainLightningTracker.renderLightning((class_3218)world, dto.getCenter(), dto.getCenter().method_1019(dto.getDirection().method_1021(context.getMaxDistance())));
                        ticks.remove(player.method_5667());
                    } else {
                        ChainLightningTracker.renderLightning((class_3218)world, dto.getCenter(), blockResult.method_17784());
                        ticks.remove(player.method_5667());
                    }
                } else {
                    dto.setCurrentTarget(entityRayCastResult);
                    dto.addDamaged(entityRayCastResult);
                    ChainLightningTracker.drawLightningBolt((class_1657)player, dto, context);
                    dto.incrementChainCount();
                }
            } else {
                class_1309 nextTarget = ChainLightningTracker.findNearestTarget(world, dto.getCurrentTarget(), dto.getDamagedTargets(), context.getChainTargetMaxDistance());
                if (nextTarget != null && dto.getCurrentChainCount() < context.getMaxChainCount()) {
                    dto.setCenter(VectorUtil.getMiddlePos(dto.getCurrentTarget()));
                    dto.setCurrentTarget(nextTarget);
                    dto.addDamaged(nextTarget);
                    ChainLightningTracker.drawLightningBolt((class_1657)player, dto, context);
                    dto.incrementChainCount();
                } else {
                    ticks.remove(player.method_5667());
                }
            }
        }
        dto.incrementTick();
    }

    private static void drawLightningBolt(class_1657 player, ChainLightningDto dto, ChainLightningSkillContext context) {
        class_3218 world = (class_3218)player.method_37908();
        class_243 start = dto.getCenter();
        class_1309 target = dto.getCurrentTarget();
        class_243 end = VectorUtil.getMiddlePos(target);
        ChainLightningTracker.renderLightning(world, start, end);
        DamageUtil.damageTargetWithElement(player, target, context.getDamage());
        world.method_8396(null, target.method_24515(), class_3417.field_14956, class_3419.field_15248, 1.0f, 1.5f);
        world.method_65096((class_2394)class_2398.field_11249, end.field_1352, end.field_1351, end.field_1350, 5, 0.01, 0.01, 0.01, 5.0);
        world.method_65096((class_2394)class_2398.field_29644, end.field_1352, end.field_1351, end.field_1350, 10, 0.01, 0.01, 0.01, 1.5);
    }

    private static class_1309 findNearestTarget(class_1937 world, class_1309 from, Set<class_1309> exclude, double range) {
        class_238 box = new class_238(from.method_19538().method_1023(range, range, range), from.method_19538().method_1031(range, range, range));
        return world.method_8390(class_1309.class, box, e -> ChainLightningTracker.isTargetCandidate(from, exclude, e)).stream().min(Comparator.comparingDouble(e -> e.method_19538().method_1022(from.method_19538()))).orElse(null);
    }

    private static boolean isTargetCandidate(class_1309 from, Set<class_1309> exclude, class_1309 e) {
        return !exclude.contains(e) && e != from && ChainLightningTracker.isDamageableEntity(e) && from.method_6057((class_1297)e);
    }

    private static void renderLightning(class_3218 world, class_243 from, class_243 to) {
        class_243 dir = to.method_1020(from).method_1029();
        double dist = from.method_1022(to);
        class_243 pos = from;
        for (double i = 0.0; i < dist; i += 0.2) {
            pos = pos.method_1019(dir.method_1021(0.2)).method_1031((random.nextDouble() - 0.5) * 0.3, (random.nextDouble() - 0.5) * 0.3, (random.nextDouble() - 0.5) * 0.3);
            world.method_65096((class_2394)class_2398.field_29644, pos.field_1352, pos.field_1351, pos.field_1350, 3, 0.01, 0.01, 0.01, 1.0);
            world.method_65096((class_2394)class_2398.field_29644, pos.field_1352, pos.field_1351, pos.field_1350, 3, 0.01, 0.01, 0.01, 0.01);
            world.method_65096((class_2394)class_2398.field_11247, pos.field_1352, pos.field_1351, pos.field_1350, 15, 0.01, 0.01, 0.01, 0.05);
            world.method_43128(null, from.method_10216(), from.method_10214(), from.method_10215(), class_3417.field_15057, class_3419.field_15248, 0.2f, 2.0f);
            world.method_43128(null, from.method_10216(), from.method_10214(), from.method_10215(), class_3417.field_20607, class_3419.field_15248, 0.2f, 0.6f);
        }
    }
}

