/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.config;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.hwijinrpg.ability.Ability;
import com.hwijinrpg.ability.context.AbilityContextsByLevel;
import com.hwijinrpg.ability.context.AbstractAbilityContext;
import com.hwijinrpg.ability.context.SimpleAbilityContext;
import com.hwijinrpg.config.AbstractJsonConfig;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;

public class AbilityContextsByLevelConfig
extends AbstractJsonConfig<Ability, HashMap<Integer, HashMap<String, Object>>> {
    private static final AbilityContextsByLevelConfig INSTANCE = new AbilityContextsByLevelConfig();
    private final HashMap<Ability, HashMap<Integer, HashMap<String, Object>>> contexts = new HashMap();

    public static AbilityContextsByLevelConfig getInstance() {
        if (AbilityContextsByLevelConfig.INSTANCE.contexts.isEmpty()) {
            INSTANCE.loadConfig();
        }
        return INSTANCE;
    }

    @Override
    protected HashMap<Ability, HashMap<Integer, HashMap<String, Object>>> getConfig() {
        return this.contexts;
    }

    @Override
    protected void initDefaultConfig() {
        for (Ability ability : Ability.values()) {
            this.contexts.put(ability, (HashMap)gson.fromJson(gson.toJson(AbilityContextsByLevel.DEFAULT_CONTEXTS.get(ability)), new TypeToken<HashMap<Integer, HashMap<String, Object>>>(){}.getType()));
        }
    }

    @Override
    protected Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("hwijinrpg/ability_contexts_by_level.json");
    }

    @Override
    protected HashMap<Integer, HashMap<String, Object>> convertValue(Ability ability, JsonElement value) {
        return (HashMap)gson.fromJson(value, new TypeToken<HashMap<Integer, HashMap<String, Object>>>(){}.getType());
    }

    public HashMap<Ability, HashMap<Integer, SimpleAbilityContext>> getSimpleAbilityContexts() {
        return (HashMap)gson.fromJson(gson.toJson(this.contexts), new TypeToken<HashMap<Ability, HashMap<Integer, SimpleAbilityContext>>>(){}.getType());
    }

    public HashMap<Integer, SimpleAbilityContext> getSimpleAbilityContexts(Ability ability) {
        return this.getSimpleAbilityContexts().get(ability);
    }

    public <T extends AbstractAbilityContext> T getAbilityContext(Ability ability, int level, Type type) {
        if (Objects.isNull(ability) || level <= 0) {
            return null;
        }
        return (T)((AbstractAbilityContext)gson.fromJson(gson.toJson(this.contexts.get(ability).get(level)), type));
    }
}

