/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.config;

import com.google.gson.JsonElement;
import com.hwijinrpg.config.AbstractJsonConfig;
import com.hwijinrpg.enumeration.ExperienceIncreaseType;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;

public class ExperienceIncreaseAmountConfig
extends AbstractJsonConfig<ExperienceIncreaseType, Double> {
    private static final ExperienceIncreaseAmountConfig INSTANCE = new ExperienceIncreaseAmountConfig();
    private final Map<ExperienceIncreaseType, Double> increaseAmount = new HashMap<ExperienceIncreaseType, Double>();

    public static ExperienceIncreaseAmountConfig getInstance() {
        if (ExperienceIncreaseAmountConfig.INSTANCE.increaseAmount.isEmpty()) {
            INSTANCE.loadConfig();
        }
        return INSTANCE;
    }

    @Override
    protected Map<ExperienceIncreaseType, Double> getConfig() {
        return this.increaseAmount;
    }

    @Override
    protected void initDefaultConfig() {
        for (ExperienceIncreaseType type : ExperienceIncreaseType.values()) {
            this.increaseAmount.put(type, type.getDefaultExp());
        }
    }

    @Override
    protected Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("hwijinrpg/exp_rewards.json");
    }

    @Override
    protected Double convertValue(ExperienceIncreaseType type, JsonElement value) {
        return value.getAsDouble();
    }

    public double getExpIncreaseAmount(ExperienceIncreaseType type) {
        if (Objects.isNull(type)) {
            return 0.0;
        }
        return this.increaseAmount.getOrDefault(type, 0.0);
    }

    public Map<ExperienceIncreaseType, Double> getIncreaseAmount() {
        return this.increaseAmount;
    }
}

