/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.enumeration;

import com.hwijinrpg.enumeration.Enumerable;
import com.hwijinrpg.enumeration.ExperienceIncreaseType;
import java.util.Arrays;
import java.util.Set;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;

public enum ExperienceType implements Enumerable
{
    MINE_LOW_CLASS_MINERAL(1, 25.0, Set.of(ExperienceIncreaseType.MINE_COPPER, ExperienceIncreaseType.MINE_GOLD, ExperienceIncreaseType.MINE_IRON), new class_1799((class_1935)class_1802.field_8620), "experience_type_description.mine_low_class_mineral"),
    MINE_HIGH_CLASS_MINERAL(2, 35.0, Set.of(ExperienceIncreaseType.MINE_DIAMOND, ExperienceIncreaseType.MINE_NETHERITE), new class_1799((class_1935)class_1802.field_8477), "experience_type_description.mine_high_class_mineral"),
    HARVEST(3, 30.0, Set.of(ExperienceIncreaseType.HARVEST), new class_1799((class_1935)class_1802.field_8861), "experience_type_description.harvest"),
    FISHING(4, 30.0, Set.of(ExperienceIncreaseType.FISHING), new class_1799((class_1935)class_1802.field_8378), "experience_type_description.fishing"),
    KILL_FRIENDLY_MOB(5, 20.0, Set.of(ExperienceIncreaseType.KILL_FRIENDLY_MOB), new class_1799((class_1935)class_1802.field_8209), "experience_type_description.kill_friendly_mob"),
    KILL_HOSTILE_MOB(6, 25.0, Set.of(ExperienceIncreaseType.KILL_HOSTILE_MOB), new class_1799((class_1935)class_1802.field_8398), "experience_type_description.kill_hostile_mob"),
    CONSUME_ITEM(7, 20.0, Set.of(ExperienceIncreaseType.CONSUME_ITEM), new class_1799((class_1935)class_1802.field_8176), "experience_type_description.consume_item"),
    ONLINE_TIME(8, 50.0, Set.of(ExperienceIncreaseType.ONLINE_TIME), new class_1799((class_1935)class_1802.field_8557), "experience_type_description.online_time");

    private final int sort;
    private final double defaultMaxAccumulatedAmountPerDay;
    private final Set<ExperienceIncreaseType> relatedIncreaseAmounts;
    private final class_1799 iconItem;
    private final String descriptionKey;

    public static ExperienceType fromIncreaseType(ExperienceIncreaseType type) {
        return Arrays.stream(ExperienceType.values()).filter(expType -> expType.getRelatedIncreaseAmounts().contains(type)).findFirst().orElse(null);
    }

    public int getSort() {
        return this.sort;
    }

    public double getDefaultMaxAccumulatedAmountPerDay() {
        return this.defaultMaxAccumulatedAmountPerDay;
    }

    public Set<ExperienceIncreaseType> getRelatedIncreaseAmounts() {
        return this.relatedIncreaseAmounts;
    }

    public class_1799 getIconItem() {
        return this.iconItem;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    private ExperienceType(int sort, double defaultMaxAccumulatedAmountPerDay, Set<ExperienceIncreaseType> relatedIncreaseAmounts, class_1799 iconItem, String descriptionKey) {
        this.sort = sort;
        this.defaultMaxAccumulatedAmountPerDay = defaultMaxAccumulatedAmountPerDay;
        this.relatedIncreaseAmounts = relatedIncreaseAmounts;
        this.iconItem = iconItem;
        this.descriptionKey = descriptionKey;
    }
}

