/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.mixin;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.ability.Ability;
import com.hwijinrpg.ability.context.LawOfTheJungleContext;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.component.RpgComponents;
import com.hwijinrpg.config.AbilityContextsByLevelConfig;
import com.hwijinrpg.job.Job;
import com.hwijinrpg.skill.SkillTracker;
import com.hwijinrpg.skill.archer.arrowrain.ArrowRainTracker;
import com.hwijinrpg.skill.archer.chainshot.ChainShotDto;
import com.hwijinrpg.skill.archer.chainshot.ChainShotTracker;
import com.hwijinrpg.skill.archer.multishot.MultiShotTracker;
import com.hwijinrpg.skill.warrior.savagecutter.SavageCutterTracker;
import com.hwijinrpg.util.ArcherUtil;
import com.hwijinrpg.util.DamageUtil;
import java.util.Objects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_9381;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin {
    @Shadow
    public abstract void method_56078(@Nullable class_3414 var1);

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleDamaged(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 self = (class_1309)this;
        LivingEntityMixin.handleSavageCutterHit(self);
        LivingEntityMixin.handleArcherSkillsHit(source, self, cir);
    }

    @Inject(method={"onDeath"}, at={@At(value="TAIL")})
    private void handleOnDeath(class_1282 source, CallbackInfo ci) {
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            PlayerRpgComponent comp = (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player);
            Integer abilityLevel = comp.getAbilities().get(Ability.LAW_OF_THE_JUNGLE);
            if (abilityLevel > 0 && player.method_7344().method_7587()) {
                LawOfTheJungleContext context = (LawOfTheJungleContext)AbilityContextsByLevelConfig.getInstance().getAbilityContext(Ability.LAW_OF_THE_JUNGLE, abilityLevel, new TypeToken<LawOfTheJungleContext>(){}.getType());
                if ((double)player.method_59922().method_43057() < context.getChance()) {
                    player.method_7344().method_7585(1, 0.5f);
                    ((class_3218)player.method_37908()).method_65096((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)-16711681), player.method_33571().method_10216(), player.method_33571().method_10214(), player.method_33571().method_10215(), 10, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Unique
    private static void handleSavageCutterHit(class_1309 self) {
        if (SavageCutterTracker.attackerAndLivingEntities.values().stream().anyMatch(entity -> Objects.equals(entity, self))) {
            LivingEntityMixin.disableDamageCooldown(self);
        }
    }

    @Unique
    private static void handleArcherSkillsHit(class_1282 source, class_1309 self, CallbackInfoReturnable<Boolean> cir) {
        class_1667 arrow;
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1667 && (class_12972 = (arrow = (class_1667)class_12972).method_24921()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            PlayerRpgComponent comp = (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player);
            if (comp.getJob() == Job.ARCHER && comp.getCurrentSkill() != null) {
                LivingEntityMixin.disableDamageCooldown(self);
                if (arrow.method_5752().contains("hwijinrpg:skill_arrow") && !SkillTracker.isDamageableEntity((class_1309)player, self)) {
                    cir.setReturnValue((Object)true);
                    return;
                }
                LivingEntityMixin.handleMultiShotHit(self, arrow, player);
                LivingEntityMixin.handleChainShotHit(self, arrow, player);
                LivingEntityMixin.handleArrowRainHit(self, arrow, player);
            }
        }
    }

    @Unique
    private static void handleMultiShotHit(class_1309 self, class_1667 arrow, class_1657 player) {
        if (MultiShotTracker.firedArrows.containsKey(arrow.method_5667()) && SkillTracker.isDamageableEntity((class_1309)player, self)) {
            DamageUtil.damageTargetWithElement(player, self, ArcherUtil.getArrowHitDamage(arrow, MultiShotTracker.firedArrows.get(arrow.method_5667()).getDamage()));
            MultiShotTracker.firedArrows.remove(arrow.method_5667());
            LivingEntityMixin.disableDamageCooldown(self);
            if (self.method_29504()) {
                arrow.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    @Unique
    private static void handleChainShotHit(class_1309 self, class_1667 arrow, class_1657 player) {
        if (ChainShotTracker.firedArrows.containsKey(arrow.method_5667()) && SkillTracker.isDamageableEntity((class_1309)player, self)) {
            ChainShotDto dto = ChainShotTracker.firedArrows.get(arrow.method_5667());
            DamageUtil.damageTargetWithElement(player, self, ArcherUtil.getArrowHitDamage(arrow, dto.getContext().getDamage()));
            dto.handleTargetHit(self, arrow);
            LivingEntityMixin.disableDamageCooldown(self);
            if (dto.isMaxArrowCountReached()) {
                ChainShotTracker.firedArrows.remove(arrow.method_5667());
            }
            if (self.method_29504()) {
                arrow.method_5650(class_1297.class_5529.field_26999);
            }
        }
    }

    @Unique
    private static void handleArrowRainHit(class_1309 self, class_1667 arrow, class_1657 player) {
        ArrowRainTracker.firedArrows.values().stream().filter(dto -> dto.getRainedArrows().stream().anyMatch(rainedArrow -> Objects.equals(rainedArrow.method_5667(), arrow.method_5667()))).findFirst().ifPresent(dto -> {
            if (SkillTracker.isDamageableEntity((class_1309)player, self)) {
                DamageUtil.damageTargetWithElement(player, self, ArcherUtil.getArrowHitDamage(arrow, dto.getContext().getDamage()));
                LivingEntityMixin.disableDamageCooldown(self);
                if (self.method_29504()) {
                    arrow.method_5650(class_1297.class_5529.field_26999);
                }
            }
        });
    }

    @Unique
    private static void disableDamageCooldown(class_1309 self) {
        self.field_6008 = 0;
        self.field_6235 = 0;
        self.field_6254 = 0;
    }
}

