/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.config;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonElement;
import com.hwijinrpg.config.AbstractJsonConfig;
import com.hwijinrpg.skill.AbstractSkillContext;
import com.hwijinrpg.skill.SimpleSkillContext;
import com.hwijinrpg.skill.Skill;
import com.hwijinrpg.skill.SkillContextsByLevel;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;

public class SkillContextsByLevelConfig
extends AbstractJsonConfig<Skill, HashMap<Integer, HashMap<String, Object>>> {
    private static final SkillContextsByLevelConfig INSTANCE = new SkillContextsByLevelConfig();
    private final HashMap<Skill, HashMap<Integer, HashMap<String, Object>>> contexts = new HashMap();

    public static SkillContextsByLevelConfig getInstance() {
        if (SkillContextsByLevelConfig.INSTANCE.contexts.isEmpty()) {
            INSTANCE.loadConfig();
        }
        return INSTANCE;
    }

    @Override
    protected HashMap<Skill, HashMap<Integer, HashMap<String, Object>>> getConfig() {
        return this.contexts;
    }

    @Override
    protected void initDefaultConfig() {
        for (Skill skill : Skill.values()) {
            this.contexts.put(skill, (HashMap)gson.fromJson(gson.toJson(SkillContextsByLevel.DEFAULT_CONTEXTS.get(skill)), new TypeToken<HashMap<Integer, HashMap<String, Object>>>(){}.getType()));
        }
    }

    @Override
    protected Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("hwijinrpg/skill_contexts_by_level.json");
    }

    @Override
    protected HashMap<Integer, HashMap<String, Object>> convertValue(Skill skill, JsonElement value) {
        return (HashMap)gson.fromJson(value, new TypeToken<HashMap<Integer, HashMap<String, Object>>>(){}.getType());
    }

    public HashMap<Skill, HashMap<Integer, SimpleSkillContext>> getSimpleSkillContexts() {
        return (HashMap)gson.fromJson(gson.toJson(this.contexts), new TypeToken<HashMap<Skill, HashMap<Integer, SimpleSkillContext>>>(){}.getType());
    }

    public HashMap<Integer, SimpleSkillContext> getSimpleSkillContexts(Skill skill) {
        return this.getSimpleSkillContexts().get(skill);
    }

    public <T extends AbstractSkillContext> T getSkillContext(Skill skill, int level, Type type) {
        if (Objects.isNull(skill) || level <= 0) {
            return null;
        }
        return (T)((AbstractSkillContext)gson.fromJson(gson.toJson(this.contexts.get(skill).get(level)), type));
    }
}

