/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.event;

import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.component.RpgComponents;
import com.hwijinrpg.enumeration.ExperienceIncreaseType;
import com.hwijinrpg.enumeration.ExperienceType;
import com.hwijinrpg.network.handler.PlayerInfoHandler;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_7923;

public class BlockBreakExpHandler {
    public static void register() {
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, blockEntity) -> {
            if (world.method_8608() || !(player instanceof class_3222)) {
                return;
            }
            class_3222 serverPlayer = (class_3222)player;
            class_2960 id = class_7923.field_41175.method_10221((Object)state.method_26204());
            BlockBreakExpHandler.handleMineOre(serverPlayer, id);
            BlockBreakExpHandler.handleHarvest(serverPlayer, state);
        });
    }

    private static void handleMineOre(class_3222 serverPlayer, class_2960 id) {
        ExperienceIncreaseType type = BlockBreakExpHandler.getExperienceIncreaseType(id);
        if (type != null && type.getIncreaseAmount() > 0.0) {
            PlayerRpgComponent comp = (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)serverPlayer);
            comp.addExperienceWithLimit(serverPlayer, ExperienceType.fromIncreaseType(type), type.getIncreaseAmount());
            PlayerInfoHandler.send(serverPlayer);
        }
    }

    private static ExperienceIncreaseType getExperienceIncreaseType(class_2960 id) {
        return switch (id.toString()) {
            case "minecraft:copper_ore", "minecraft:deepslate_copper_ore" -> ExperienceIncreaseType.MINE_COPPER;
            case "minecraft:iron_ore", "minecraft:deepslate_iron_ore" -> ExperienceIncreaseType.MINE_IRON;
            case "minecraft:gold_ore", "minecraft:deepslate_gold_ore" -> ExperienceIncreaseType.MINE_GOLD;
            case "minecraft:lapis_ore", "minecraft:deepslate_lapis_ore" -> ExperienceIncreaseType.MINE_LAPIS;
            case "minecraft:diamond_ore", "minecraft:deepslate_diamond_ore" -> ExperienceIncreaseType.MINE_DIAMOND;
            case "minecraft:ancient_debris" -> ExperienceIncreaseType.MINE_NETHERITE;
            default -> null;
        };
    }

    private static void handleHarvest(class_3222 serverPlayer, class_2680 state) {
        if (!state.method_26164(class_3481.field_20341)) {
            return;
        }
        boolean fullyGrown = false;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof class_2302) {
            class_2302 crop = (class_2302)class_22482;
            fullyGrown = crop.method_9825(state);
        } else {
            for (class_2769 p : state.method_28501()) {
                int maxAge;
                if (!(p instanceof class_2758)) continue;
                class_2758 ip = (class_2758)p;
                if (!"age".equals(p.method_11899())) continue;
                int age = (Integer)state.method_11654((class_2769)ip);
                fullyGrown = age >= (maxAge = ip.method_11898().stream().mapToInt(Integer::intValue).max().orElse(7));
                break;
            }
        }
        if (!fullyGrown) {
            return;
        }
        PlayerRpgComponent comp = (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)serverPlayer);
        comp.addExperienceWithLimit(serverPlayer, ExperienceType.HARVEST, ExperienceIncreaseType.HARVEST.getIncreaseAmount());
        PlayerInfoHandler.send(serverPlayer);
    }
}

