/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.network.handler;

import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.component.RpgComponents;
import com.hwijinrpg.enumeration.ResetType;
import com.hwijinrpg.job.Job;
import com.hwijinrpg.network.handler.PlayerInfoHandler;
import com.hwijinrpg.network.payload.RequestResetPayload;
import com.hwijinrpg.util.PersistentAbilityUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class ResetHandler {
    public static void handle(RequestResetPayload payload, class_3222 player) {
        PlayerRpgComponent comp = (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player);
        switch (payload.type()) {
            case AP: {
                ResetHandler.handleResetAp(comp, payload.type(), player);
                break;
            }
            case SP: {
                ResetHandler.handleResetSp(comp, payload.type(), player);
                break;
            }
            case JOB: {
                ResetHandler.handleResetJob(comp, payload.type(), player);
            }
        }
    }

    private static void handleResetAp(PlayerRpgComponent comp, ResetType type, class_3222 player) {
        if (comp.getAp() >= comp.getLevel() / 5) {
            player.method_64398((class_2561)class_2561.method_43471((String)"reset_ap.failed_by_unused_ap").method_54663(-65536));
            return;
        }
        if (ResetHandler.validateDiamondCount(player, type)) {
            comp.resetAbilitiesAndAp();
            PersistentAbilityUtil.handleResetAbility(player, comp);
            ResetHandler.deductDiamonds(player, type.getRequiredDiamondCount());
            player.method_7346();
            player.method_64398((class_2561)class_2561.method_43469((String)"reset_ap.reset_completed", (Object[])new Object[]{type.getRequiredDiamondCount()}).method_54663(-16711936));
        }
    }

    private static void handleResetSp(PlayerRpgComponent comp, ResetType type, class_3222 player) {
        if (comp.getSp() + 1 >= comp.getLevel()) {
            player.method_64398((class_2561)class_2561.method_43471((String)"reset_sp.failed_by_unused_sp").method_54663(-65536));
            return;
        }
        if (ResetHandler.validateDiamondCount(player, type)) {
            comp.resetSkillsAndSp();
            ResetHandler.deductDiamonds(player, type.getRequiredDiamondCount());
            player.method_7346();
            player.method_64398((class_2561)class_2561.method_43469((String)"reset_sp.reset_completed", (Object[])new Object[]{type.getRequiredDiamondCount()}).method_54663(-16711936));
            PlayerInfoHandler.send(player);
        }
    }

    private static void handleResetJob(PlayerRpgComponent comp, ResetType type, class_3222 player) {
        if (comp.getJob() == Job.BEGINNER) {
            player.method_64398((class_2561)class_2561.method_43471((String)"reset_job.failed_by_beginner").method_54663(-65536));
            return;
        }
        if (ResetHandler.validateDiamondCount(player, type)) {
            comp.resetJob();
            comp.resetSkillsAndSp();
            ResetHandler.deductDiamonds(player, type.getRequiredDiamondCount());
            player.method_7346();
            player.method_64398((class_2561)class_2561.method_43469((String)"reset_job.reset_completed", (Object[])new Object[]{type.getRequiredDiamondCount()}).method_54663(-16711936));
            PlayerInfoHandler.send(player);
        }
    }

    private static boolean validateDiamondCount(class_3222 player, ResetType type) {
        int diamondAmountInInventory = ResetHandler.getDiamondCountInInventory(player);
        if (diamondAmountInInventory < type.getRequiredDiamondCount()) {
            player.method_64398((class_2561)class_2561.method_43469((String)"reset.failed_by_insufficient_diamonds", (Object[])new Object[]{type.getRequiredDiamondCount(), diamondAmountInInventory}).method_54663(-65536));
            return false;
        }
        return true;
    }

    private static int getDiamondCountInInventory(class_3222 player) {
        int diamondCount = 0;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7909() != class_1802.field_8477) continue;
            diamondCount += stack.method_7947();
        }
        return diamondCount;
    }

    public static boolean deductDiamonds(class_3222 player, int amountToDeduct) {
        int remaining = amountToDeduct;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7909() != class_1802.field_8477) continue;
            int stackCount = stack.method_7947();
            if (stackCount <= remaining) {
                player.method_31548().method_5447(i, class_1799.field_8037);
                remaining -= stackCount;
            } else {
                stack.method_7934(remaining);
                remaining = 0;
            }
            if (remaining == 0) break;
        }
        player.method_31548().method_5431();
        return true;
    }
}

