/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill.archer.chainshot;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.skill.Skill;
import com.hwijinrpg.skill.SkillTracker;
import com.hwijinrpg.skill.archer.chainshot.ChainShotDto;
import com.hwijinrpg.skill.archer.chainshot.ChainShotSkillContext;
import com.hwijinrpg.skill.archer.chainshot.TargetIgnoreableArrowEntity;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_9381;

public class ChainShotTracker
extends SkillTracker {
    public static final Map<UUID, ChainShotDto> firedArrows = new ConcurrentHashMap<UUID, ChainShotDto>();

    public static void start(class_3222 player, ChainShotSkillContext context, class_1667 arrow) {
        arrow.method_7438(0.001);
        arrow.method_5780("hwijinrpg:skill_arrow");
        ChainShotDto dto = new ChainShotDto(context, player, arrow);
        dto.getDamagedTargets().add((class_1309)player);
        firedArrows.put(arrow.method_5667(), dto);
    }

    public static void tick(class_1937 world, class_3222 player, PlayerRpgComponent comp) {
        HashSet removeTargets = new HashSet();
        firedArrows.entrySet().stream().filter(entry -> Objects.equals(((ChainShotDto)entry.getValue()).getShotPlayer().method_5667(), player.method_5667())).forEach(entry -> {
            if (!Objects.equals(((ChainShotDto)entry.getValue()).getLastHitEntity(), player) && ((ChainShotDto)entry.getValue()).getTickPassedAfterLastArrow() == 1) {
                ChainShotTracker.findNextTargetAndShotNewArrow(world, player, comp, entry, removeTargets);
            } else if (((ChainShotDto)entry.getValue()).getTickPassedAfterLastArrow() > 400) {
                removeTargets.add((UUID)entry.getKey());
            }
            ((ChainShotDto)entry.getValue()).incrementTick();
            ChainShotTracker.drawTail((class_3218)world, (UUID)entry.getKey());
        });
        removeTargets.forEach(firedArrows::remove);
    }

    private static void findNextTargetAndShotNewArrow(class_1937 world, class_3222 player, PlayerRpgComponent comp, Map.Entry<UUID, ChainShotDto> entry, Set<UUID> removeTargets) {
        ChainShotSkillContext context = (ChainShotSkillContext)SkillContextsByLevelConfig.getInstance().getSkillContext(Skill.CHAIN_SHOT, comp.getSkills().get(Skill.CHAIN_SHOT), new TypeToken<ChainShotSkillContext>(){}.getType());
        ChainShotDto dto = entry.getValue();
        class_1309 nextTarget = ChainShotTracker.findNearestTarget(world, dto.getLastHitEntity(), dto.getDamagedTargets(), context.getChainTargetMaxDistance());
        if (nextTarget == null) {
            removeTargets.add(entry.getKey());
            return;
        }
        dto.changeDirection(nextTarget);
        TargetIgnoreableArrowEntity arrow = new TargetIgnoreableArrowEntity(world, dto.getLastArrowLocation().method_10216(), dto.getLastArrowLocation().method_10214(), dto.getLastArrowLocation().method_10215(), dto.getItemStack(), dto.getShotFrom());
        arrow.method_7485(dto.getDirection().method_10216(), dto.getDirection().method_10214(), dto.getDirection().method_10215(), dto.getSpeed(), 0.0f);
        arrow.method_7438(0.001);
        arrow.method_5780("hwijinrpg:skill_arrow");
        arrow.method_7432((class_1297)player);
        arrow.field_7572 = class_1665.class_1666.field_7592;
        arrow.addIgnoredTargets(dto.getDamagedTargets());
        world.method_8649((class_1297)arrow);
        world.method_43128(null, arrow.method_23317(), arrow.method_23318(), arrow.method_23321(), class_3417.field_28598, class_3419.field_15248, 1.0f, 2.0f);
        world.method_43128(null, arrow.method_23317(), arrow.method_23318(), arrow.method_23321(), class_3417.field_14698, class_3419.field_15248, 1.0f, -1.0f);
        removeTargets.add(entry.getKey());
        firedArrows.put(arrow.method_5667(), dto);
    }

    private static class_1309 findNearestTarget(class_1937 world, class_1309 from, Set<class_1309> exclude, double range) {
        class_238 box = new class_238(from.method_19538().method_1023(range, range, range), from.method_19538().method_1031(range, range, range));
        return world.method_8390(class_1309.class, box, e -> ChainShotTracker.isTargetCandidate(from, exclude, e)).stream().min(Comparator.comparingDouble(e -> e.method_19538().method_1022(from.method_19538()))).orElse(null);
    }

    private static boolean isTargetCandidate(class_1309 from, Set<class_1309> exclude, class_1309 e) {
        return !exclude.contains(e) && ChainShotTracker.isDamageableEntity(from, e) && from.method_6057((class_1297)e);
    }

    private static void drawTail(class_3218 world, UUID key) {
        class_1297 entity = world.method_66347(key);
        if (entity instanceof class_1667) {
            class_1667 arrow = (class_1667)entity;
            world.method_65096((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)-12810569), arrow.method_23317(), arrow.method_23318(), arrow.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

