/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill.archer.gravityarrow;

import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.skill.SkillTracker;
import com.hwijinrpg.skill.archer.gravityarrow.GravityArrowDto;
import com.hwijinrpg.skill.archer.gravityarrow.GravityArrowSkillContext;
import com.hwijinrpg.util.DamageUtil;
import com.hwijinrpg.util.EffectUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_9381;

public class GravityArrowTracker
extends SkillTracker {
    public static final Map<UUID, GravityArrowDto> firedArrows = new HashMap<UUID, GravityArrowDto>();

    public static void start(class_3222 player, GravityArrowSkillContext context, class_1667 arrow) {
        arrow.method_7438(0.001);
        arrow.method_5780("hwijinrpg:skill_arrow");
        firedArrows.put(arrow.method_5667(), new GravityArrowDto(context, player, arrow));
    }

    public static void tick(class_1937 world, class_3222 player, PlayerRpgComponent comp) {
        HashSet removeTargets = new HashSet();
        firedArrows.entrySet().stream().filter(entry -> Objects.equals(((GravityArrowDto)entry.getValue()).getShotPlayer().method_5667(), player.method_5667())).collect(Collectors.toSet()).forEach(entry -> {
            if (((GravityArrowDto)entry.getValue()).isGravityStarted()) {
                GravityArrowTracker.internalHandle(world, player, entry, removeTargets);
            } else {
                GravityArrowTracker.drawTail((class_3218)world, (UUID)entry.getKey());
            }
        });
        removeTargets.forEach(firedArrows::remove);
    }

    private static void internalHandle(class_1937 world, class_3222 player, Map.Entry<UUID, GravityArrowDto> entry, Set<UUID> removeTargets) {
        List targets;
        class_3218 serverWorld = (class_3218)world;
        GravityArrowDto dto = entry.getValue();
        GravityArrowSkillContext context = dto.getContext();
        if (!dto.isGravityStarted() || dto.getCenter() == null) {
            return;
        }
        class_243 center = dto.getCenter();
        int tick = dto.getTickPassed();
        if (tick == 0) {
            serverWorld.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_38830, class_3419.field_15248, 5.0f, -1.0f);
        }
        if (tick % 8 == 0 && tick <= 32) {
            serverWorld.method_65096((class_2394)class_2398.field_11221, center.field_1352, center.field_1351, center.field_1350, 5, 0.2, 0.2, 0.2, 0.01);
            serverWorld.method_65096((class_2394)class_2398.field_11251, center.field_1352, center.field_1351, center.field_1350, 10, 0.3, 0.1, 0.3, 0.01);
            double radius = context.getGravityArea();
            targets = serverWorld.method_8390(class_1309.class, new class_238(center.method_1023(radius, radius, radius), center.method_1031(radius, radius, radius)), e -> GravityArrowTracker.isDamageableEntity((class_1309)player, e));
            double sphereScale = (radius * 3.0 - 1.0) / (3.0 + (double)tick / 8.0);
            EffectUtil.createSphereEffect(serverWorld, center, sphereScale, 10, 15, -16777088);
            for (class_1309 target : targets) {
                DamageUtil.damageTargetWithElement((class_1657)player, target, (float)context.getGravityDamage());
                serverWorld.method_65096((class_2394)class_2398.field_11251, target.method_23317(), target.method_23318(), target.method_23321(), 1, 0.0, 0.0, 0.0, 0.01);
            }
        }
        if (tick % 3 == 0 && tick <= 36) {
            List targets2 = serverWorld.method_8390(class_1309.class, new class_238(center.method_1023(context.getGravityArea(), context.getGravityArea(), context.getGravityArea()), center.method_1031(context.getGravityArea(), context.getGravityArea(), context.getGravityArea())), e -> GravityArrowTracker.isDamageableEntity((class_1309)player, e));
            for (class_1309 target : targets2) {
                try {
                    target.method_18799(new class_243(center.method_10216() - target.method_23317(), (center.method_10214() - target.method_23318()) / 2.0, center.method_10215() - target.method_23321()).method_1029().method_1021(2.0));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (tick == 40) {
            double explosionRadius = context.getGravityArea() * 2.0 / 3.0;
            targets = serverWorld.method_8390(class_1309.class, new class_238(center.method_1023(explosionRadius, explosionRadius, explosionRadius), center.method_1031(explosionRadius, explosionRadius, explosionRadius)), e -> GravityArrowTracker.isDamageableEntity((class_1309)player, e));
            serverWorld.method_65096((class_2394)class_2398.field_23114, center.field_1352, center.field_1351, center.field_1350, (int)context.getGravityArea() * 2, 0.5, 0.5, 0.5, 1.0);
            serverWorld.method_65096((class_2394)class_2398.field_22246, center.field_1352, center.field_1351, center.field_1350, (int)context.getGravityArea() * 30, 1.0, 1.0, 1.0, 1.0);
            serverWorld.method_65096((class_2394)class_2398.field_17909, center.field_1352, center.field_1351, center.field_1350, (int)context.getGravityArea(), 0.2, 0.2, 0.2, 0.0);
            serverWorld.method_65096((class_2394)new class_2390(-16777088, 1.0f), center.field_1352, center.field_1351, center.field_1350, 50, 3.0, 3.0, 3.0, 3.0);
            serverWorld.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_14803, class_3419.field_15248, 5.0f, 0.3f);
            for (class_1309 target : targets) {
                DamageUtil.damageTargetWithElement((class_1657)player, target, context.getDamage());
                target.method_18799(new class_243(target.method_23317() - center.method_10216(), target.method_23318() - center.method_10214() + 1.0, target.method_23321() - center.method_10215()).method_1029());
            }
            removeTargets.add(entry.getKey());
        }
        dto.incrementTick();
    }

    private static void drawTail(class_3218 world, UUID key) {
        class_1297 entity = world.method_66347(key);
        if (entity instanceof class_1667) {
            class_1667 arrow = (class_1667)entity;
            world.method_65096((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)-16777088), arrow.method_23317(), arrow.method_23318(), arrow.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

