/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill.mage.gravityflux;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.network.handler.PlayerInfoHandler;
import com.hwijinrpg.skill.Skill;
import com.hwijinrpg.skill.SkillTracker;
import com.hwijinrpg.skill.mage.gravityflux.GravityFluxDto;
import com.hwijinrpg.skill.mage.gravityflux.GravityFluxSkillContext;
import com.hwijinrpg.util.DamageUtil;
import com.hwijinrpg.util.EffectUtil;
import com.hwijinrpg.util.VectorUtil;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;
import net.minecraft.class_9381;

public class GravityFluxTracker
extends SkillTracker {
    private static final Map<UUID, GravityFluxDto> ticks = new HashMap<UUID, GravityFluxDto>();

    public static void start(class_3222 player) {
        ticks.put(player.method_5667(), new GravityFluxDto());
    }

    public static void tick(class_1937 world, class_3222 player, PlayerRpgComponent comp) {
        class_243 vel;
        GravityFluxSkillContext context = (GravityFluxSkillContext)SkillContextsByLevelConfig.getInstance().getSkillContext(Skill.GRAVITY_FLUX, comp.getSkills().get(Skill.GRAVITY_FLUX), new TypeToken<GravityFluxSkillContext>(){}.getType());
        GravityFluxDto dto = ticks.get(player.method_5667());
        if (dto == null || context == null) {
            GravityFluxTracker.cancel(player.method_5667());
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (dto.getTickPassed() == 1) {
            dto.initCenter((class_1657)player, context);
            if (dto.getCenter() == null) {
                GravityFluxTracker.cancel(player.method_5667());
                comp.getSkillCoolTimeByTicks().put(Skill.GRAVITY_FLUX, 20);
                PlayerInfoHandler.send(player);
                return;
            }
            serverWorld.method_43128(null, dto.getCenter().field_1352, dto.getCenter().field_1351, dto.getCenter().field_1350, class_3417.field_38068, class_3419.field_15248, 3.0f, -1.0f);
            EffectUtil.createCircularEffect(serverWorld, dto.getCenter(), context.getTargetArea() - 1.0, 6, 50, -16776961);
            serverWorld.method_65096((class_2394)class_2398.field_38908, dto.getCenter().field_1352, dto.getCenter().field_1351, dto.getCenter().field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            serverWorld.method_65096((class_2394)class_2398.field_23114, dto.getCenter().field_1352, dto.getCenter().field_1351, dto.getCenter().field_1350, 20, context.getTargetArea(), 0.2, context.getTargetArea(), 0.1);
            List<class_1309> targets = serverWorld.method_8390(class_1309.class, new class_238(dto.getCenter().method_1023(context.getTargetArea(), context.getTargetArea(), context.getTargetArea()), dto.getCenter().method_1031(context.getTargetArea(), context.getTargetArea(), context.getTargetArea())), e -> GravityFluxTracker.isDamageableEntity((class_1309)player, e)).stream().filter(e -> dto.getCenter().method_1022(e.method_19538()) <= (double)(context.getMaxDistance() - 1)).sorted(Comparator.comparingDouble(e -> e.method_5707(dto.getCenter()))).limit(context.getMaxTargetCount()).toList();
            if (targets.isEmpty()) {
                GravityFluxTracker.cancel(player.method_5667());
                return;
            }
            dto.setTargets(targets);
            serverWorld.method_43128(null, dto.getCenter().field_1352, dto.getCenter().field_1351, dto.getCenter().field_1350, class_3417.field_38831, class_3419.field_15248, 3.0f, -1.0f);
            for (class_1309 target : targets) {
                DamageUtil.damageTargetWithElement((class_1657)player, target, context.getLaunchDamage());
                target.field_6017 = 0.0;
                class_243 middle = VectorUtil.getMiddlePos(target);
                serverWorld.method_65096((class_2394)class_2398.field_23114, middle.method_10216(), middle.method_10214(), middle.method_10215(), 10, 0.2, 0.2, 0.2, 0.01);
                serverWorld.method_65096((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)-16776961), middle.method_10216(), middle.method_10214(), middle.method_10215(), 10, 0.0, 0.0, 0.0, 0.0);
                serverWorld.method_65096((class_2394)class_2398.field_38908, middle.method_10216(), middle.method_10214(), middle.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (dto.getTickPassed() == 11) {
            for (class_1309 target : dto.getTargets()) {
                vel = target.method_18798();
                target.method_18799(new class_243(vel.field_1352 / 3.0, 2.5, vel.field_1350 / 3.0));
                target.field_6007 = true;
                target.field_6037 = true;
                target.field_6017 = 0.0;
                world.method_43128(null, target.method_23317(), target.method_23318(), target.method_23321(), class_3417.field_14702, class_3419.field_15248, 2.0f, -1.0f);
            }
        }
        if (dto.getTickPassed() == 19) {
            for (class_1309 target : dto.getTargets()) {
                vel = target.method_18798();
                target.method_18799(new class_243(vel.field_1352 / 5.0, 0.04, vel.field_1350 / 5.0));
                target.field_6007 = true;
                target.field_6037 = true;
                target.method_5875(true);
            }
        }
        if (dto.getTickPassed() == 54) {
            for (class_1309 target : dto.getTargets()) {
                vel = target.method_18798();
                target.method_5875(false);
                target.method_18799(new class_243(vel.field_1352, -3.5, vel.field_1350));
                target.field_6007 = true;
                target.field_6037 = true;
                target.field_6017 = 0.0;
                dto.getDropped().add(target);
            }
        }
        for (class_1309 target : dto.getDropped()) {
            if (dto.getDamaged().contains(target) || !target.method_24828() || !(target.method_18798().field_1351 <= 0.1)) continue;
            DamageUtil.damageTargetWithElement((class_1657)player, target, context.getDamage());
            dto.getDamaged().add(target);
            world.method_60511(null, target.method_23317(), target.method_23318(), target.method_23321(), (class_6880)class_3417.field_15152, class_3419.field_15248, 2.0f, -1.0f);
            serverWorld.method_65096((class_2394)class_2398.field_49139, target.method_23317(), target.method_23318(), target.method_23321(), 2, 0.0, 0.0, 0.0, 1.0);
            serverWorld.method_65096((class_2394)class_2398.field_11248, target.method_23317(), target.method_23318(), target.method_23321(), 20, 0.0, 0.0, 0.0, 1.0);
        }
        dto.incrementTick();
    }

    private static void cancel(UUID uuid) {
        ticks.remove(uuid);
    }
}

