/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill.warrior.dash;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.skill.Skill;
import com.hwijinrpg.skill.SkillTracker;
import com.hwijinrpg.skill.warrior.dash.DashDto;
import com.hwijinrpg.skill.warrior.dash.DashSkillContext;
import com.hwijinrpg.util.DamageUtil;
import com.hwijinrpg.util.VectorUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class DashTracker
extends SkillTracker {
    private static final Map<UUID, DashDto> ticks = new HashMap<UUID, DashDto>();

    public static void start(class_3222 player) {
        ticks.put(player.method_5667(), new DashDto());
    }

    public static void tick(class_1937 world, class_3222 player, PlayerRpgComponent comp) {
        DashSkillContext context = (DashSkillContext)SkillContextsByLevelConfig.getInstance().getSkillContext(Skill.DASH, comp.getSkills().get(Skill.DASH), new TypeToken<DashSkillContext>(){}.getType());
        DashDto dto = ticks.get(player.method_5667());
        if (dto == null) {
            return;
        }
        class_243 attackCenterPosition = VectorUtil.getMiddlePos((class_1309)player);
        DashTracker.hitEnemiesInFront((class_1657)player, attackCenterPosition, context, dto);
        DashTracker.spawnParticles((class_1657)player, attackCenterPosition);
        dto.incrementTick();
        if (dto.getTickPassed() >= 7) {
            DashTracker.stopPlayer((class_1657)player);
            ticks.remove(player.method_5667());
        }
    }

    private static void stopPlayer(class_1657 player) {
        class_243 originalDir = player.method_5828(1.0f);
        class_243 dir = originalDir.method_1031(0.0, -originalDir.field_1351, 0.0).method_1029();
        player.method_18800(dir.method_10216() * 0.3, player.method_18798().method_10214(), dir.method_10215() * 0.3);
        player.field_6037 = true;
    }

    private static void hitEnemiesInFront(class_1657 player, class_243 attackCenterPosition, DashSkillContext context, DashDto dto) {
        class_243 dir = player.method_5828(1.0f).method_1029();
        class_238 area = new class_238(attackCenterPosition, attackCenterPosition.method_1019(dir.method_1021((double)context.getSpeed()))).method_1009(1.0 * (double)context.getDamageArea(), 0.8 * (double)context.getDamageArea(), 1.0 * (double)context.getDamageArea());
        for (class_1297 entity : player.method_37908().method_8335((class_1297)player, area)) {
            class_1309 target;
            if (!(entity instanceof class_1309) || (target = (class_1309)entity).method_5655() || !DashTracker.isDamageableEntity((class_1309)player, target) || dto.getDamagedTargets().contains(target.method_5667())) continue;
            DamageUtil.damageTargetWithElement(player, target, context.getDamage());
            target.method_5762(dir.field_1352 * 0.2, 0.05, dir.field_1350 * 0.2);
            dto.handleDamaged(target);
        }
    }

    public static void spawnParticles(class_1657 player, class_243 attackCenterPosition) {
        ((class_3218)player.method_37908()).method_65096((class_2394)class_2398.field_11227, attackCenterPosition.method_10216(), attackCenterPosition.method_10214(), attackCenterPosition.method_10215(), 3, 0.6, 0.6, 0.6, 0.1);
    }
}

