/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.validator;

import com.hwijinrpg.ability.Ability;
import com.hwijinrpg.ability.context.AbstractAbilityContext;
import com.hwijinrpg.config.AbilityContextsByLevelConfig;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.interfaces.PlayerData;
import com.hwijinrpg.skill.AbstractSkillContext;
import com.hwijinrpg.skill.Skill;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class LevelUpValidator {
    public static boolean isAbilityLevelUpAvailable(Ability ability, int currentAbilityLevel, PlayerData playerData, @Nullable class_3222 player) {
        if (currentAbilityLevel >= AbilityContextsByLevelConfig.getInstance().getSimpleAbilityContexts(ability).size()) {
            if (Objects.nonNull(player)) {
                player.method_64398((class_2561)class_2561.method_43469((String)"ability.max_ability_level", (Object[])new Object[]{class_2561.method_43471((String)ability.getDisplayNameKey())}).method_54663(-65536));
            }
            return false;
        }
        AbstractAbilityContext nextLevelAbilityContext = AbilityContextsByLevelConfig.getInstance().getSimpleAbilityContexts(ability).get(currentAbilityLevel + 1);
        if (playerData.getLevel() < nextLevelAbilityContext.getRequiredLevel()) {
            if (Objects.nonNull(player)) {
                player.method_64398((class_2561)class_2561.method_43469((String)"ability.insufficient_level", (Object[])new Object[]{nextLevelAbilityContext.getRequiredLevel()}).method_54663(-65536));
            }
            return false;
        }
        if (playerData.getAp() < nextLevelAbilityContext.getRequiredAp()) {
            if (Objects.nonNull(player)) {
                player.method_64398((class_2561)class_2561.method_43469((String)"ability.insufficient_ap", (Object[])new Object[]{nextLevelAbilityContext.getRequiredAp()}).method_54663(-65536));
            }
            return false;
        }
        if (ability == Ability.FIRE_ELEMENT_SKILL && playerData.getAbilities().get(Ability.ICE_ELEMENT_SKILL) > 0 || ability == Ability.ICE_ELEMENT_SKILL && playerData.getAbilities().get(Ability.FIRE_ELEMENT_SKILL) > 0) {
            if (Objects.nonNull(player)) {
                player.method_64398((class_2561)class_2561.method_43471((String)"ability.fire_with_ice_element_not_allowed").method_54663(-65536));
            }
            return false;
        }
        return true;
    }

    public static boolean isSkillLevelUpAvailable(Skill skill, int currentSkillLevel, PlayerData playerData, @Nullable class_3222 player) {
        if (currentSkillLevel >= SkillContextsByLevelConfig.getInstance().getSimpleSkillContexts(skill).size()) {
            if (Objects.nonNull(player)) {
                player.method_64398((class_2561)class_2561.method_43469((String)"skill.max_skill_level", (Object[])new Object[]{class_2561.method_43471((String)skill.getDisplayNameKey())}).method_54663(-65536));
            }
            return false;
        }
        if (!Objects.equals((Object)playerData.getJob(), (Object)skill.getAvailableJob())) {
            if (Objects.nonNull(player)) {
                player.method_64398((class_2561)class_2561.method_43469((String)"skill.different_job", (Object[])new Object[]{skill, class_2561.method_43471((String)skill.getAvailableJob().getDisplayNameKey())}).method_54663(-65536));
            }
            return false;
        }
        AbstractSkillContext nextLevelSkillContext = SkillContextsByLevelConfig.getInstance().getSimpleSkillContexts(skill).get(currentSkillLevel + 1);
        if (playerData.getLevel() < nextLevelSkillContext.getRequiredLevel()) {
            if (Objects.nonNull(player)) {
                player.method_64398((class_2561)class_2561.method_43469((String)"skill.insufficient_level", (Object[])new Object[]{nextLevelSkillContext.getRequiredLevel()}).method_54663(-65536));
            }
            return false;
        }
        if (playerData.getSp() < nextLevelSkillContext.getRequiredSp()) {
            if (Objects.nonNull(player)) {
                player.method_64398((class_2561)class_2561.method_43469((String)"skill.insufficient_sp", (Object[])new Object[]{nextLevelSkillContext.getRequiredSp()}).method_54663(-65536));
            }
            return false;
        }
        return true;
    }
}

