/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg;

import com.hwijinrpg.event.ClientTickHandler;
import com.hwijinrpg.gui.RpgMainScreen;
import com.hwijinrpg.holder.PlayerDataHolder;
import com.hwijinrpg.holder.ServerDataHolder;
import com.hwijinrpg.input.KeyBindingManager;
import com.hwijinrpg.job.Job;
import com.hwijinrpg.network.payload.RpgPlayerInfoPayload;
import com.hwijinrpg.network.payload.ServerDataPayload;
import com.hwijinrpg.skill.Skill;
import io.wispforest.owo.ui.container.FlowLayout;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class HwijinRpgModClient
implements ClientModInitializer {
    public void onInitializeClient() {
        KeyBindingManager.register();
        this.registerPacketReceivers();
        this.registerHandlers();
    }

    private void registerPacketReceivers() {
        ClientPlayNetworking.registerGlobalReceiver(RpgPlayerInfoPayload.ID, (payload, context) -> {
            PlayerDataHolder.syncedAp = payload.ap();
            PlayerDataHolder.syncedSp = payload.sp();
            PlayerDataHolder.syncedLevel = payload.level();
            PlayerDataHolder.syncedExp = (double)Math.round(payload.exp() * 10.0) / 10.0;
            PlayerDataHolder.syncedExpToNext = payload.expToNext();
            PlayerDataHolder.currentJob = Job.valueOf(payload.job());
            PlayerDataHolder.currentSkill = payload.currentSkill() == null || payload.currentSkill().isEmpty() ? null : Skill.valueOf(payload.currentSkill());
            PlayerDataHolder.experienceSummary.clear();
            PlayerDataHolder.experienceSummary.putAll(payload.experienceSummary());
            PlayerDataHolder.abilities.clear();
            PlayerDataHolder.abilities.putAll(payload.abilitySummary());
            PlayerDataHolder.skills.clear();
            PlayerDataHolder.skills.putAll(payload.skillSummary().entrySet().stream().filter(skill -> Objects.equals((Object)((Skill)skill.getKey()).getAvailableJob(), (Object)PlayerDataHolder.currentJob)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            PlayerDataHolder.skillCoolTimeByTicks.clear();
            PlayerDataHolder.skillCoolTimeByTicks.putAll(payload.skillCoolTimeByTicks().entrySet().stream().filter(skill -> Objects.equals((Object)((Skill)skill.getKey()).getAvailableJob(), (Object)PlayerDataHolder.currentJob)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            class_310 client = class_310.method_1551();
            class_437 patt0$temp = client.field_1755;
            if (patt0$temp instanceof RpgMainScreen) {
                RpgMainScreen screen = (RpgMainScreen)patt0$temp;
                FlowLayout rootComponent = (FlowLayout)screen.getAdapter().rootComponent;
                rootComponent.clearChildren();
                screen.build(rootComponent);
            }
        });
        ClientPlayNetworking.registerGlobalReceiver(ServerDataPayload.ID, (payload, context) -> {
            ServerDataHolder.simpleAbilityContexts.clear();
            ServerDataHolder.simpleAbilityContexts.putAll(payload.simpleAbilityContexts());
            ServerDataHolder.simpleSkillContexts.clear();
            ServerDataHolder.simpleSkillContexts.putAll(payload.simpleSkillContexts());
            ServerDataHolder.experienceIncreaseAmounts.clear();
            ServerDataHolder.experienceIncreaseAmounts.putAll(payload.experienceIncreaseAmounts());
            ServerDataHolder.maxAccumulatedExperiencePerDays.clear();
            ServerDataHolder.maxAccumulatedExperiencePerDays.putAll(payload.maxAccumulatedExperiencePerDays());
        });
    }

    private void registerHandlers() {
        ClientTickHandler.register();
    }
}

