/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.event;

import com.hwijinrpg.ability.tracker.AbilityTracker;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.component.RpgComponents;
import com.hwijinrpg.enumeration.ExperienceIncreaseType;
import com.hwijinrpg.enumeration.ExperienceType;
import com.hwijinrpg.network.handler.PlayerInfoHandler;
import com.hwijinrpg.skill.Skill;
import com.hwijinrpg.skill.archer.arrowrain.ArrowRainTracker;
import com.hwijinrpg.skill.archer.chainshot.ChainShotTracker;
import com.hwijinrpg.skill.archer.gravityarrow.GravityArrowTracker;
import com.hwijinrpg.skill.archer.multishot.MultiShotTracker;
import com.hwijinrpg.skill.mage.astrafield.AstraFieldTracker;
import com.hwijinrpg.skill.mage.chainlightning.ChainLightningTracker;
import com.hwijinrpg.skill.mage.energyorb.EnergyOrbTracker;
import com.hwijinrpg.skill.mage.gravityflux.GravityFluxTracker;
import com.hwijinrpg.skill.warrior.aircutter.AirCutterTracker;
import com.hwijinrpg.skill.warrior.dash.DashTracker;
import com.hwijinrpg.skill.warrior.exposivesword.ExplosiveSwordTracker;
import com.hwijinrpg.skill.warrior.savagecutter.SavageCutterTracker;
import com.hwijinrpg.util.DelayedTaskUtil;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerTickHandler {
    private static final Map<class_3222, Integer> tickCounter = new HashMap<class_3222, Integer>();

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            DelayedTaskUtil.init();
            for (class_3222 player : server.method_3760().method_14571()) {
                PlayerRpgComponent comp = (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player);
                ServerTickHandler.handleOnlineTime(player, comp);
                ServerTickHandler.handleDayPassed(comp);
                ServerTickHandler.handleSkillCoolTime(comp);
                ServerTickHandler.handleSkillTicks(player);
            }
            ServerTickHandler.handleAbilityTick(server);
        });
    }

    private static void handleOnlineTime(class_3222 player, PlayerRpgComponent comp) {
        tickCounter.put(player, tickCounter.getOrDefault(player, 0) + 1);
        if (tickCounter.get(player) >= 1200) {
            tickCounter.put(player, 0);
            comp.addExperienceWithLimit(player, ExperienceType.ONLINE_TIME, ExperienceIncreaseType.ONLINE_TIME.getIncreaseAmount());
            PlayerInfoHandler.send(player);
        }
    }

    private static void handleDayPassed(PlayerRpgComponent comp) {
        LocalDate today = LocalDate.now();
        if (!today.equals(comp.getLastResetDate())) {
            comp.initAccumulatedExps();
            comp.setLastResetDate(today);
        }
    }

    private static void handleSkillCoolTime(PlayerRpgComponent comp) {
        comp.getSkillCoolTimeByTicks().entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).forEach(entry -> comp.getSkillCoolTimeByTicks().put((Skill)entry.getKey(), (Integer)entry.getValue() - 1));
    }

    private static void handleSkillTicks(class_3222 player) {
        DashTracker.tick(player.method_37908(), player, (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player));
        SavageCutterTracker.tick(player.method_37908(), player, (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player));
        AirCutterTracker.tick(player.method_37908(), player, (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player));
        ExplosiveSwordTracker.tick(player.method_37908(), player, (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player));
        EnergyOrbTracker.tick(player.method_37908(), player, (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player));
        ChainLightningTracker.tick(player.method_37908(), player, (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player));
        AstraFieldTracker.tick(player.method_37908(), player, (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player));
        GravityFluxTracker.tick(player.method_37908(), player, (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player));
        MultiShotTracker.tick(player.method_37908(), player, (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player));
        ChainShotTracker.tick(player.method_37908(), player, (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player));
        ArrowRainTracker.tick(player.method_37908(), player, (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player));
        GravityArrowTracker.tick(player.method_37908(), player, (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player));
    }

    private static void handleAbilityTick(MinecraftServer server) {
        AbilityTracker.tick(server);
    }
}

