/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.network.handler;

import com.hwijinrpg.ability.Ability;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.component.RpgComponents;
import com.hwijinrpg.network.handler.PlayerInfoHandler;
import com.hwijinrpg.network.payload.RequestAbilityLevelUpPayload;
import com.hwijinrpg.util.PersistentAbilityUtil;
import com.hwijinrpg.validator.LevelUpValidator;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class AbilityLevelUpHandler {
    public static void handle(RequestAbilityLevelUpPayload payload, class_3222 player) {
        PlayerRpgComponent comp = (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player);
        if (!AbilityLevelUpHandler.validate(payload, comp, player)) {
            return;
        }
        comp.levelUpAbility(payload.ability());
        AbilityLevelUpHandler.applyAbility(player, payload.ability(), comp);
        player.method_64398((class_2561)class_2561.method_43469((String)"ability.level_up_completed", (Object[])new Object[]{class_2561.method_43471((String)payload.ability().getDisplayNameKey()), comp.getAbilities().get(payload.ability())}).method_54663(-16711936));
        PlayerInfoHandler.send(player);
    }

    private static boolean validate(RequestAbilityLevelUpPayload payload, PlayerRpgComponent comp, class_3222 player) {
        return LevelUpValidator.isAbilityLevelUpAvailable(payload.ability(), comp.getAbilities().getOrDefault(payload.ability(), 0), comp, player);
    }

    private static void applyAbility(class_3222 player, Ability ability, PlayerRpgComponent comp) {
        switch (ability) {
            case INCREASE_HP: {
                PersistentAbilityUtil.handleIncreaseHp(player, comp);
                break;
            }
            case INCREASE_MOVEMENT_SPEED_AND_JUMP_STRENGTH: {
                PersistentAbilityUtil.handleMovementSpeedAndJumpStrength(player, comp);
                break;
            }
            case INCREASE_BLOCK_BREAK_SPEED: {
                PersistentAbilityUtil.handleBlockBreakSpeed(player, comp);
            }
        }
    }
}

