/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill.archer.arrowrain;

import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.config.RpgConfig;
import com.hwijinrpg.skill.archer.arrowrain.ArrowRainDto;
import com.hwijinrpg.skill.archer.arrowrain.ArrowRainSkillContext;
import com.hwijinrpg.skill.archer.chainshot.TargetIgnoreableArrowEntity;
import com.hwijinrpg.util.EffectUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_9381;

public class ArrowRainTracker {
    public static final Map<UUID, ArrowRainDto> firedArrows = new HashMap<UUID, ArrowRainDto>();
    private static final Random random = new Random(System.currentTimeMillis());

    public static void start(class_3222 player, ArrowRainSkillContext context, class_1667 arrow) {
        arrow.method_7438(0.001);
        firedArrows.put(arrow.method_5667(), new ArrowRainDto(context, player, arrow));
    }

    public static void tick(class_1937 world, class_3222 player, PlayerRpgComponent comp) {
        HashSet removeTargets = new HashSet();
        firedArrows.entrySet().stream().filter(entry -> Objects.equals(((ArrowRainDto)entry.getValue()).getShotPlayer().method_5667(), player.method_5667())).collect(Collectors.toSet()).forEach(entry -> {
            if (((ArrowRainDto)entry.getValue()).isRainStarted()) {
                ArrowRainTracker.internalHandle(world, player, comp, entry, removeTargets);
            } else {
                ArrowRainTracker.drawTail((class_3218)world, (UUID)entry.getKey());
            }
        });
        removeTargets.forEach(firedArrows::remove);
    }

    private static void internalHandle(class_1937 world, class_3222 player, PlayerRpgComponent comp, Map.Entry<UUID, ArrowRainDto> entry, Set<UUID> removeTargets) {
        ArrowRainDto dto = entry.getValue();
        if (dto.getTickPassed() == 0) {
            EffectUtil.createCircularEffect((class_3218)world, dto.getRainCenter(), dto.getContext().getTargetArea() - 0.5, 6, 50, -65536);
        }
        for (int i = 0; i < dto.getContext().getArrowCount() / 20 + 1; ++i) {
            if (dto.getFiredArrowCount() < dto.getContext().getArrowCount()) {
                ArrowRainTracker.rainArrowWithRandomPosition(world, player, comp, dto);
                dto.incrementFiredArrowCount();
                continue;
            }
            if (dto.getTickPassed() <= 200) continue;
            dto.clear();
            removeTargets.add(entry.getKey());
        }
        dto.incrementTick();
    }

    private static void rainArrowWithRandomPosition(class_1937 world, class_3222 player, PlayerRpgComponent comp, ArrowRainDto dto) {
        class_243 arrowSpawnPosition = ArrowRainTracker.getRandomPosition(world, dto);
        if (arrowSpawnPosition == null) {
            return;
        }
        TargetIgnoreableArrowEntity arrow = new TargetIgnoreableArrowEntity(world, arrowSpawnPosition.method_10216(), arrowSpawnPosition.method_10214(), arrowSpawnPosition.method_10215(), dto.getItemStack(), dto.getShotFrom());
        arrow.method_7485((random.nextDouble() - 0.5) * 0.1, -1.0 - random.nextDouble() * 0.2, (random.nextDouble() - 0.5) * 0.1, dto.getSpeed(), 0.0f);
        arrow.method_7438(0.001);
        arrow.method_7432((class_1297)player);
        arrow.field_7572 = class_1665.class_1666.field_7592;
        if (RpgConfig.getInstance().isPvpEnabled()) {
            arrow.addIgnoredTargets(Set.of(player));
        } else {
            arrow.addIgnoredTargets(new HashSet<class_1309>(world.method_8503().method_3760().method_14571()));
        }
        dto.addRainedArrow(arrow);
        world.method_8649((class_1297)arrow);
        world.method_43128(null, arrowSpawnPosition.method_10216(), arrowSpawnPosition.method_10214(), arrowSpawnPosition.method_10215(), class_3417.field_14600, class_3419.field_15248, 2.0f, 0.9f + dto.getSpeed() / 30.0f);
    }

    private static class_243 getRandomPosition(class_1937 world, ArrowRainDto dto) {
        for (int i = 0; i < 3; ++i) {
            double z;
            double x = dto.getRainCenter().method_10216() + dto.getContext().getTargetArea() * Math.cos(Math.toRadians(random.nextDouble() * 360.0)) * random.nextDouble();
            Double y = ArrowRainTracker.getY(world, x, z = dto.getRainCenter().method_10215() + dto.getContext().getTargetArea() * Math.sin(Math.toRadians(random.nextDouble() * 360.0)) * random.nextDouble(), dto.getRainCenter().method_10214());
            if (y == null) continue;
            return new class_243(x, y.doubleValue(), z);
        }
        return null;
    }

    private static Double getY(class_1937 world, double x, double z, double originalY) {
        class_2338 pos;
        class_2680 blockState;
        double currentY = originalY;
        int maxHeight = 20;
        for (int i = 0; !(i >= maxHeight || (blockState = world.method_8320(pos = new class_2338((int)x, (int)originalY + i + 1, (int)z))).method_26212((class_1922)world, pos) && currentY != originalY); ++i) {
            currentY = originalY + (double)i + 1.0;
        }
        if (currentY == originalY) {
            return null;
        }
        return currentY;
    }

    private static void drawTail(class_3218 world, UUID key) {
        class_1297 entity = world.method_14190(key);
        if (entity instanceof class_1667) {
            class_1667 arrow = (class_1667)entity;
            world.method_65096((class_2394)class_9381.method_58256((class_2396)class_2398.field_11226, (int)-65536), arrow.method_23317(), arrow.method_23318(), arrow.method_23321(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

