/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill.archer.multishot;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.skill.Skill;
import com.hwijinrpg.skill.archer.multishot.MultiShotDto;
import com.hwijinrpg.skill.archer.multishot.MultiShotSkillContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class MultiShotTracker {
    public static final Map<UUID, MultiShotSkillContext> firedArrows = new HashMap<UUID, MultiShotSkillContext>();
    private static final Map<UUID, MultiShotDto> ticks = new HashMap<UUID, MultiShotDto>();
    private static final Random random = new Random(System.currentTimeMillis());

    public static void start(class_3222 player, MultiShotSkillContext context, class_1667 arrow) {
        ticks.put(player.method_5667(), new MultiShotDto(context, player, arrow));
        arrow.method_5650(class_1297.class_5529.field_26999);
    }

    public static void tick(class_1937 world, class_3222 player, PlayerRpgComponent comp) {
        MultiShotSkillContext context = (MultiShotSkillContext)SkillContextsByLevelConfig.getInstance().getSkillContext(Skill.MULTI_SHOT, comp.getSkills().get(Skill.MULTI_SHOT), new TypeToken<MultiShotSkillContext>(){}.getType());
        MultiShotDto dto = ticks.get(player.method_5667());
        if (dto == null || context == null) {
            return;
        }
        if (dto.isMaxArrowCountReached()) {
            ticks.remove(player.method_5667());
            return;
        }
        MultiShotTracker.createArrow(world, player, comp, context, dto);
        dto.incrementTick();
    }

    private static void createArrow(class_1937 world, class_3222 player, PlayerRpgComponent comp, MultiShotSkillContext context, MultiShotDto dto) {
        class_243 start = player.method_33571();
        class_243 direction = MultiShotTracker.getRandomizedDirection(player, context.getAccuracy());
        class_1667 arrow = new class_1667(world, start.method_10216() + direction.method_10216(), start.method_10214() + direction.method_10214(), start.method_10215() + direction.method_10215(), dto.getItemStack(), dto.getShotFrom());
        arrow.method_7485(direction.method_10216(), direction.method_10214(), direction.method_10215(), dto.getSpeed(), 0.0f);
        arrow.method_7438(0.001);
        arrow.method_7432((class_1297)player);
        arrow.field_7572 = class_1665.class_1666.field_7592;
        world.method_8649((class_1297)arrow);
        world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14600, class_3419.field_15248, 5.0f, 0.9f + dto.getSpeed() / 30.0f);
        firedArrows.put(arrow.method_5667(), context);
    }

    private static class_243 getRandomizedDirection(class_3222 player, int accuracy) {
        class_243 direction = player.method_5828(1.0f).method_1029();
        return new class_243(direction.method_10216() + MultiShotTracker.getRandomValueByAccuracy(accuracy), direction.method_10214() + MultiShotTracker.getRandomValueByAccuracy(accuracy), direction.method_10215() + MultiShotTracker.getRandomValueByAccuracy(accuracy));
    }

    private static double getRandomValueByAccuracy(double accuracy) {
        return (double)random.nextFloat() / accuracy - 1.0 / accuracy / 2.0;
    }
}

