/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill.warrior.aircutter;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.skill.Skill;
import com.hwijinrpg.skill.SkillTracker;
import com.hwijinrpg.skill.warrior.aircutter.AirCutterDto;
import com.hwijinrpg.skill.warrior.aircutter.AirCutterSkillContext;
import com.hwijinrpg.util.DamageUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class AirCutterTracker
extends SkillTracker {
    private static final Map<UUID, AirCutterDto> ticks = new HashMap<UUID, AirCutterDto>();

    public static void start(class_3222 player) {
        ticks.put(player.method_5667(), new AirCutterDto());
    }

    public static void tick(class_1937 world, class_3222 player, PlayerRpgComponent comp) {
        AirCutterSkillContext context = (AirCutterSkillContext)SkillContextsByLevelConfig.getInstance().getSkillContext(Skill.AIR_CUTTER, comp.getSkills().get(Skill.AIR_CUTTER), new TypeToken<AirCutterSkillContext>(){}.getType());
        AirCutterDto dto = ticks.get(player.method_5667());
        if (dto == null || context == null) {
            return;
        }
        if (dto.getTickPassed() < 2) {
            dto.incrementTick();
            return;
        }
        if (dto.getTickPassed() == 2) {
            dto.initCenterAndDirection((class_1657)player);
            world.method_43128(null, dto.getCenter().method_10216(), dto.getCenter().method_10214(), dto.getCenter().method_10215(), class_3417.field_14588, class_3419.field_15248, 0.8f, 1.5f);
        }
        if (dto.getTickPassed() >= 2) {
            AirCutterTracker.drawCrescentAndDamage((class_1657)player, dto, context);
            world.method_43128(null, dto.getCenter().method_10216(), dto.getCenter().method_10214(), dto.getCenter().method_10215(), class_3417.field_38365, class_3419.field_15248, 0.3f, -1.0f);
            if ((float)dto.getTickPassed() >= context.getDistance()) {
                ticks.remove(player.method_5667());
            } else {
                dto.incrementTick();
            }
        }
    }

    private static void drawCrescentAndDamage(class_1657 player, AirCutterDto dto, AirCutterSkillContext context) {
        class_243 center = dto.getCenter();
        class_243 forward = dto.getDirection();
        double outerR = (double)context.getSize() * 1.5;
        double innerR = (double)context.getSize() * 1.2;
        int density = 32;
        class_243 right = forward.method_1036(new class_243(0.0, 1.0, 0.0)).method_1029();
        class_243 up = right.method_1036(forward).method_1029();
        class_243 rotatedUp = up.method_1021(Math.cos(Math.toRadians(30.0))).method_1019(right.method_1021(Math.sin(Math.toRadians(30.0))));
        class_1937 world = player.method_37908();
        for (double theta = 0.0; theta < Math.PI; theta += Math.PI / (double)density) {
            for (double r = innerR; r <= outerR; r += 0.1) {
                double y = r * Math.cos(theta);
                double z = r * Math.sin(theta);
                class_243 position = center.method_1019(forward.method_1021(z)).method_1019(rotatedUp.method_1021(y));
                ((class_3218)player.method_37908()).method_65096((class_2394)class_2398.field_28479, position.method_10216(), position.method_10214(), position.method_10215(), 1, 0.0, 0.0, 0.0, 0.0);
                class_238 hitbox = new class_238(position.method_1023(0.6, 0.6, 0.6), position.method_1031(0.6, 0.6, 0.6));
                List targets = world.method_8390(class_1309.class, hitbox, e -> AirCutterTracker.isDamageableEntity((class_1309)player, e) && !dto.getDamagedTargets().contains(e.method_5667()));
                for (class_1309 target : targets) {
                    DamageUtil.damageTargetWithElement(player, target, context.getDamage());
                    dto.handleDamaged(target);
                }
            }
        }
    }
}

