/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.component;

import com.hwijinrpg.ability.Ability;
import com.hwijinrpg.config.AbilityContextsByLevelConfig;
import com.hwijinrpg.config.ExperienceMaxAccumulatedAmountPerDayConfig;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.enumeration.ExperienceType;
import com.hwijinrpg.interfaces.PlayerData;
import com.hwijinrpg.job.Job;
import com.hwijinrpg.skill.Skill;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.ladysnake.cca.api.v3.component.Component;

public class PlayerRpgComponent
implements Component,
PlayerData {
    private Map<ExperienceType, Double> accumulatedExps = Arrays.stream(ExperienceType.values()).collect(Collectors.toMap(Function.identity(), experienceType -> 0.0));
    private Map<Ability, Integer> abilities = Arrays.stream(Ability.values()).collect(Collectors.toMap(Function.identity(), ability -> 0));
    private Map<Skill, Integer> skills = Arrays.stream(Skill.values()).collect(Collectors.toMap(Function.identity(), skill -> 0));
    private Map<Skill, Integer> skillCoolTimeByTicks = Arrays.stream(Skill.values()).collect(Collectors.toMap(Function.identity(), skill -> 0));
    private LocalDate lastResetDate = LocalDate.now();
    private int ap = 0;
    private int sp = 0;
    private int level = 1;
    private double experience = 0.0;
    private Skill currentSkill = null;
    private Job job = Job.BEGINNER;

    public double getAccumulatedExps(ExperienceType type) {
        return this.accumulatedExps.getOrDefault(type, 0.0);
    }

    public void addExperienceWithLimit(class_3222 player, ExperienceType type, double amount) {
        double limit;
        double current = this.getAccumulatedExps(type);
        if (current >= (limit = ExperienceMaxAccumulatedAmountPerDayConfig.getInstance().getMaxAccumulatedAmountPerDay(type))) {
            return;
        }
        double allowed = Math.min(amount, limit - current);
        this.accumulatedExps.put(type, current + allowed);
        this.addExperience(player, allowed);
    }

    private void addExperience(class_3222 player, double amount) {
        this.experience += amount;
        while (this.experience >= (double)this.getExpToNextLevel()) {
            this.handleLevelUp(player);
        }
    }

    private void handleLevelUp(class_3222 currentPlayer) {
        this.experience -= (double)this.getExpToNextLevel();
        ++this.level;
        ++this.sp;
        if (this.level % 5 == 0) {
            ++this.ap;
        }
        for (class_3222 serverPlayer : currentPlayer.method_5682().method_3760().method_14571()) {
            serverPlayer.method_7353((class_2561)class_2561.method_43469((String)"level_up", (Object[])new Object[]{currentPlayer.method_5476(), this.level}).method_54663(-16711936), false);
        }
        currentPlayer.method_37908().method_43128(null, currentPlayer.method_23317(), currentPlayer.method_23318(), currentPlayer.method_23321(), class_3417.field_14709, class_3419.field_15248, 1.0f, 1.5f);
    }

    public int getExpToNextLevel() {
        return 20 + (this.level - 1) * 10;
    }

    public void resetAbilitiesAndAp() {
        this.initAbilities();
        this.ap = this.level / 5;
    }

    public void resetSkillsAndSp() {
        this.initSkills();
        this.initSkillCoolTimes();
        this.sp = this.level - 1;
        this.currentSkill = null;
    }

    public void resetJob() {
        this.job = Job.BEGINNER;
    }

    public void initAccumulatedExps() {
        this.accumulatedExps = Arrays.stream(ExperienceType.values()).collect(Collectors.toMap(Function.identity(), experienceType -> 0.0));
    }

    private void initAbilities() {
        this.abilities = Arrays.stream(Ability.values()).collect(Collectors.toMap(Function.identity(), ability -> 0));
    }

    private void initSkills() {
        this.skills = Arrays.stream(Skill.values()).collect(Collectors.toMap(Function.identity(), skill -> 0));
    }

    private void initSkillCoolTimes() {
        this.skillCoolTimeByTicks = Arrays.stream(Skill.values()).collect(Collectors.toMap(Function.identity(), skill -> 0));
    }

    public void levelUpAbility(Ability ability) {
        this.abilities.put(ability, this.abilities.getOrDefault(ability, 0) + 1);
        this.ap -= AbilityContextsByLevelConfig.getInstance().getSimpleAbilityContexts(ability).get(this.abilities.get(ability)).getRequiredAp();
    }

    public void levelUpSkill(Skill skill) {
        this.skills.put(skill, this.skills.getOrDefault(skill, 0) + 1);
        this.sp -= SkillContextsByLevelConfig.getInstance().getSimpleSkillContexts(skill).get(this.skills.get(skill)).getRequiredSp();
    }

    public boolean isCoolTime(Skill skill) {
        return this.skillCoolTimeByTicks.getOrDefault(skill, 0) > 0;
    }

    public boolean isNotCoolTime(Skill skill) {
        return !this.isCoolTime(skill);
    }

    public void readFromNbt(class_2487 nbtCompound, @NotNull class_7225.class_7874 wrapperLookup) {
        class_2487 mapTag;
        this.accumulatedExps.clear();
        this.abilities.clear();
        this.skills.clear();
        this.skillCoolTimeByTicks.clear();
        if (nbtCompound.method_10545("accumulatedExps") && nbtCompound.method_10562("accumulatedExps").method_10546() > 0) {
            mapTag = nbtCompound.method_10562("accumulatedExps");
            for (Enum enum_ : ExperienceType.values()) {
                if (mapTag.method_10545(enum_.name())) {
                    this.accumulatedExps.put((ExperienceType)enum_, mapTag.method_10574(enum_.name()));
                    continue;
                }
                this.accumulatedExps.put((ExperienceType)enum_, 0.0);
            }
        } else {
            this.initAccumulatedExps();
        }
        if (nbtCompound.method_10545("abilities") && nbtCompound.method_10562("abilities").method_10546() > 0) {
            mapTag = nbtCompound.method_10562("abilities");
            for (Enum enum_ : Ability.values()) {
                if (mapTag.method_10545(enum_.name())) {
                    this.abilities.put((Ability)enum_, mapTag.method_10550(enum_.name()));
                    continue;
                }
                this.abilities.put((Ability)enum_, 0);
            }
        } else {
            this.initAbilities();
        }
        if (nbtCompound.method_10545("skills") && nbtCompound.method_10562("skills").method_10546() > 0) {
            mapTag = nbtCompound.method_10562("skills");
            for (Enum enum_ : Skill.values()) {
                if (mapTag.method_10545(enum_.name())) {
                    this.skills.put((Skill)enum_, mapTag.method_10550(enum_.name()));
                    continue;
                }
                this.skills.put((Skill)enum_, 0);
            }
        } else {
            this.initSkills();
        }
        if (nbtCompound.method_10545("skillCoolTimeByTicks") && nbtCompound.method_10562("skillCoolTimeByTicks").method_10546() > 0) {
            mapTag = nbtCompound.method_10562("skillCoolTimeByTicks");
            for (Enum enum_ : Skill.values()) {
                if (mapTag.method_10545(enum_.name())) {
                    this.skillCoolTimeByTicks.put((Skill)enum_, mapTag.method_10550(enum_.name()));
                    continue;
                }
                this.skillCoolTimeByTicks.put((Skill)enum_, 0);
            }
        } else {
            this.initSkillCoolTimes();
        }
        if (nbtCompound.method_10545("lastResetDate")) {
            this.lastResetDate = LocalDate.parse(nbtCompound.method_10558("lastResetDate"));
        }
        this.ap = nbtCompound.method_10550("ap");
        this.sp = nbtCompound.method_10550("sp");
        this.level = nbtCompound.method_10550("level");
        this.experience = nbtCompound.method_10574("experience");
        if (nbtCompound.method_10545("job")) {
            this.job = Job.valueOf(nbtCompound.method_10558("job"));
        }
        if (nbtCompound.method_10545("currentSkill")) {
            this.currentSkill = Skill.valueOf(nbtCompound.method_10558("currentSkill"));
        }
    }

    public void writeToNbt(@NotNull class_2487 nbtCompound, @NotNull class_7225.class_7874 wrapperLookup) {
        class_2487 expMapTag = new class_2487();
        class_2487 abilityMapTag = new class_2487();
        class_2487 skillMapTag = new class_2487();
        class_2487 skillCoolTimeMapTag = new class_2487();
        for (Map.Entry<ExperienceType, Double> entry : this.accumulatedExps.entrySet()) {
            expMapTag.method_10549(entry.getKey().name(), entry.getValue().doubleValue());
        }
        for (Map.Entry<Enum, Number> entry : this.abilities.entrySet()) {
            abilityMapTag.method_10569(((Ability)entry.getKey()).name(), ((Integer)entry.getValue()).intValue());
        }
        for (Map.Entry<Enum, Number> entry : this.skills.entrySet()) {
            skillMapTag.method_10569(((Skill)entry.getKey()).name(), ((Integer)entry.getValue()).intValue());
        }
        for (Map.Entry<Enum, Number> entry : this.skillCoolTimeByTicks.entrySet()) {
            skillCoolTimeMapTag.method_10569(((Skill)entry.getKey()).name(), ((Integer)entry.getValue()).intValue());
        }
        nbtCompound.method_10566("accumulatedExps", (class_2520)expMapTag);
        nbtCompound.method_10566("abilities", (class_2520)abilityMapTag);
        nbtCompound.method_10566("skills", (class_2520)skillMapTag);
        nbtCompound.method_10566("skillCoolTimeByTicks", (class_2520)skillCoolTimeMapTag);
        nbtCompound.method_10582("lastResetDate", this.lastResetDate.toString());
        nbtCompound.method_10569("ap", this.ap);
        nbtCompound.method_10569("sp", this.sp);
        nbtCompound.method_10569("level", this.level);
        nbtCompound.method_10549("experience", this.experience);
        nbtCompound.method_10582("job", this.job.name());
        if (this.currentSkill != null) {
            nbtCompound.method_10582("currentSkill", this.currentSkill.name());
        }
    }

    public Map<ExperienceType, Double> getAccumulatedExps() {
        return this.accumulatedExps;
    }

    @Override
    public Map<Ability, Integer> getAbilities() {
        return this.abilities;
    }

    @Override
    public Map<Skill, Integer> getSkills() {
        return this.skills;
    }

    public Map<Skill, Integer> getSkillCoolTimeByTicks() {
        return this.skillCoolTimeByTicks;
    }

    public LocalDate getLastResetDate() {
        return this.lastResetDate;
    }

    @Override
    public int getAp() {
        return this.ap;
    }

    @Override
    public int getSp() {
        return this.sp;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    public double getExperience() {
        return this.experience;
    }

    public Skill getCurrentSkill() {
        return this.currentSkill;
    }

    @Override
    public Job getJob() {
        return this.job;
    }

    public void setLastResetDate(LocalDate lastResetDate) {
        this.lastResetDate = lastResetDate;
    }

    public void setCurrentSkill(Skill currentSkill) {
        this.currentSkill = currentSkill;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public static final class Fields {
        public static final String accumulatedExps = "accumulatedExps";
        public static final String abilities = "abilities";
        public static final String skills = "skills";
        public static final String skillCoolTimeByTicks = "skillCoolTimeByTicks";
        public static final String lastResetDate = "lastResetDate";
        public static final String ap = "ap";
        public static final String sp = "sp";
        public static final String level = "level";
        public static final String experience = "experience";
        public static final String currentSkill = "currentSkill";
        public static final String job = "job";
    }
}

