/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.config;

import com.google.gson.JsonElement;
import com.hwijinrpg.config.AbstractJsonConfig;
import com.hwijinrpg.enumeration.RpgConfigKey;
import com.hwijinrpg.weapon.Material;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;

public class RpgConfig
extends AbstractJsonConfig<RpgConfigKey, Object> {
    private static final RpgConfig INSTANCE = new RpgConfig();
    private final Map<RpgConfigKey, Object> configs = new HashMap<RpgConfigKey, Object>();

    public static RpgConfig getInstance() {
        if (RpgConfig.INSTANCE.configs.isEmpty()) {
            INSTANCE.loadConfig();
        }
        return INSTANCE;
    }

    @Override
    protected Map<RpgConfigKey, Object> getConfig() {
        return this.configs;
    }

    @Override
    protected void initDefaultConfig() {
        for (RpgConfigKey rpgConfigKey : RpgConfigKey.values()) {
            this.configs.put(rpgConfigKey, rpgConfigKey.getDefaultValue());
        }
    }

    @Override
    protected Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("hwijinrpg/rpg_config.json");
    }

    @Override
    protected Object convertValue(RpgConfigKey key, JsonElement value) {
        if (key.getExpectedType() == Double.class) {
            return value.getAsDouble();
        }
        if (key.getExpectedType() == Integer.class) {
            return value.getAsInt();
        }
        if (key.getExpectedType() == Boolean.class) {
            return value.getAsBoolean();
        }
        if (key.getExpectedType() == String.class) {
            return value.getAsString();
        }
        if (key.getExpectedType() == Material.class) {
            return Material.valueOf(value.getAsString().toUpperCase());
        }
        return value;
    }

    public boolean isPvpEnabled() {
        return (Boolean)this.configs.getOrDefault(RpgConfigKey.PVP_ENABLED, RpgConfigKey.PVP_ENABLED.getDefaultValue());
    }
}

