/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.config;

import com.google.gson.JsonElement;
import com.hwijinrpg.config.AbstractJsonConfig;
import com.hwijinrpg.enumeration.ExperienceType;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.loader.api.FabricLoader;

public class ExperienceMaxAccumulatedAmountPerDayConfig
extends AbstractJsonConfig<ExperienceType, Double> {
    private static final ExperienceMaxAccumulatedAmountPerDayConfig INSTANCE = new ExperienceMaxAccumulatedAmountPerDayConfig();
    private final Map<ExperienceType, Double> maxAccumulatedAmountPerDay = new HashMap<ExperienceType, Double>();

    public static ExperienceMaxAccumulatedAmountPerDayConfig getInstance() {
        if (ExperienceMaxAccumulatedAmountPerDayConfig.INSTANCE.maxAccumulatedAmountPerDay.isEmpty()) {
            INSTANCE.loadConfig();
        }
        return INSTANCE;
    }

    @Override
    protected Map<ExperienceType, Double> getConfig() {
        return this.maxAccumulatedAmountPerDay;
    }

    @Override
    protected void initDefaultConfig() {
        for (ExperienceType type : ExperienceType.values()) {
            this.maxAccumulatedAmountPerDay.put(type, type.getDefaultMaxAccumulatedAmountPerDay());
        }
    }

    @Override
    protected Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir().resolve("hwijinrpg/max_exp_per_day.json");
    }

    @Override
    protected Double convertValue(ExperienceType type, JsonElement value) {
        return value.getAsDouble();
    }

    public double getMaxAccumulatedAmountPerDay(ExperienceType type) {
        if (Objects.isNull(type)) {
            return 0.0;
        }
        return this.maxAccumulatedAmountPerDay.getOrDefault(type, 0.0);
    }

    public Map<ExperienceType, Double> getMaxAccumulatedAmountPerDay() {
        return this.maxAccumulatedAmountPerDay;
    }
}

