/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.mixin.client;

import com.hwijinrpg.holder.PlayerDataHolder;
import com.hwijinrpg.network.payload.UseSkillPayload;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_636;
import net.minecraft.class_8710;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_636.class})
public class ClientPlayerInteractionManagerMixin {
    @Inject(method={"interactItem"}, at={@At(value="HEAD")})
    private void onInteractItem(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (ClientPlayerInteractionManagerMixin.isSkillSelected() && ClientPlayerInteractionManagerMixin.isNotCoolTime() && this.isSkillImmediatelyUsableJob()) {
            ClientPlayNetworking.send((class_8710)new UseSkillPayload(PlayerDataHolder.currentSkill));
        }
    }

    @Unique
    private boolean isSkillImmediatelyUsableJob() {
        return PlayerDataHolder.currentJob.isSkillImmediatelyUsable();
    }

    @Unique
    private static boolean isSkillSelected() {
        return PlayerDataHolder.currentSkill != null;
    }

    @Unique
    private static boolean isNotCoolTime() {
        return PlayerDataHolder.skillCoolTimeByTicks.getOrDefault(PlayerDataHolder.currentSkill, 0) <= 0;
    }
}

