/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.network.handler;

import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.component.RpgComponents;
import com.hwijinrpg.job.Job;
import com.hwijinrpg.network.payload.UseSkillPayload;
import com.hwijinrpg.skill.SkillHandlerProvider;
import com.hwijinrpg.validator.SkillValidator;
import net.minecraft.class_1753;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1829;
import net.minecraft.class_3222;

public class UseSkillHandler {
    public static void handle(UseSkillPayload payload, class_3222 player) {
        PlayerRpgComponent comp = (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player);
        if (UseSkillHandler.isSkillSelectable(payload, comp) && UseSkillHandler.isNotCoolTime(payload, comp) && UseSkillHandler.isUsingAvailableWeapon(player, comp)) {
            SkillHandlerProvider.get(payload.skill()).handle(player);
        }
    }

    private static boolean isSkillSelectable(UseSkillPayload payload, PlayerRpgComponent comp) {
        return SkillValidator.isSkillSelectable(payload.skill(), comp);
    }

    private static boolean isNotCoolTime(UseSkillPayload payload, PlayerRpgComponent comp) {
        return comp.isNotCoolTime(payload.skill());
    }

    private static boolean isUsingAvailableWeapon(class_3222 player, PlayerRpgComponent comp) {
        return switch (comp.getJob()) {
            default -> throw new MatchException(null, null);
            case Job.BEGINNER -> false;
            case Job.WARRIOR -> UseSkillHandler.getMainHandItemOfPlayer(player) instanceof class_1829;
            case Job.MAGE -> UseSkillHandler.getMainHandItemOfPlayer(player) instanceof class_1794;
            case Job.ARCHER -> UseSkillHandler.getMainHandItemOfPlayer(player) instanceof class_1753;
        };
    }

    private static class_1792 getMainHandItemOfPlayer(class_3222 player) {
        return player.method_6047().method_7909();
    }
}

