/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill.warrior.savagecutter;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.skill.Skill;
import com.hwijinrpg.skill.SkillTracker;
import com.hwijinrpg.skill.warrior.savagecutter.SavageCutterSkillContext;
import com.hwijinrpg.util.DamageUtil;
import com.hwijinrpg.util.VectorUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class SavageCutterTracker
extends SkillTracker {
    private static final Map<UUID, Integer> ticks = new HashMap<UUID, Integer>();
    private static final Random random = new Random(System.currentTimeMillis());
    public static final Map<UUID, class_1309> attackerAndLivingEntities = new HashMap<UUID, class_1309>();

    public static void start(class_3222 player) {
        ticks.put(player.method_5667(), 0);
    }

    public static void tick(class_1937 world, class_3222 player, PlayerRpgComponent comp) {
        int ticksPassed;
        SavageCutterSkillContext context = (SavageCutterSkillContext)SkillContextsByLevelConfig.getInstance().getSkillContext(Skill.SAVAGE_CUTTER, comp.getSkills().get(Skill.SAVAGE_CUTTER), new TypeToken<SavageCutterSkillContext>(){}.getType());
        Integer skillTicks = ticks.get(player.method_5667());
        if (skillTicks == null) {
            return;
        }
        if (ticks.get(player.method_5667()) % 3 == 0) {
            class_243 attackCenterPosition = VectorUtil.getMiddlePos((class_1309)player);
            SavageCutterTracker.hitEnemiesInFront((class_1657)player, attackCenterPosition, context);
            player.method_23667(class_1268.field_5808, true);
            SavageCutterTracker.playSound((class_1657)player);
            SavageCutterTracker.spawnParticles((class_1657)player, attackCenterPosition);
        }
        if ((ticksPassed = skillTicks + 1) >= context.getHitCount() * 3) {
            ticks.remove(player.method_5667());
            attackerAndLivingEntities.remove(player.method_5667());
        } else {
            ticks.put(player.method_5667(), ticksPassed);
        }
    }

    private static void hitEnemiesInFront(class_1657 player, class_243 attackCenterPosition, SavageCutterSkillContext context) {
        class_243 dir = player.method_5828(1.0f).method_1029();
        class_238 area = new class_238(attackCenterPosition, attackCenterPosition.method_1019(dir.method_1021(2.0))).method_1009(2.0, 2.0, 2.0);
        for (class_1297 entity : player.method_37908().method_8335((class_1297)player, area)) {
            class_1309 target;
            if (!(entity instanceof class_1309) || !SavageCutterTracker.isDamageableEntity((class_1309)player, target = (class_1309)entity) || target.method_5655()) continue;
            DamageUtil.damageTargetWithElement(player, target, context.getDamage());
            attackerAndLivingEntities.put(player.method_5667(), target);
        }
    }

    private static void playSound(class_1657 player) {
        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), (class_3414)class_3417.field_49044.comp_349(), class_3419.field_15248, 0.9f, 1.8f + random.nextFloat() / 5.0f);
    }

    public static void spawnParticles(class_1657 player, class_243 attackCenterPosition) {
        class_243 directionValue = player.method_5720().method_1021(2.0);
        class_243 position = attackCenterPosition.method_1019(directionValue);
        ((class_3218)player.method_37908()).method_14199((class_2394)class_2398.field_11227, position.method_10216(), position.method_10214(), position.method_10215(), 1, 0.1, 0.1, 0.1, 0.5);
        ((class_3218)player.method_37908()).method_14199((class_2394)class_2398.field_17909, position.method_10216(), position.method_10214(), position.method_10215(), 1, 0.1, 0.1, 0.1, 0.5);
    }
}

