/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg;

import com.hwijinrpg.component.RpgComponents;
import com.hwijinrpg.event.BlockBreakExpHandler;
import com.hwijinrpg.event.EntityKillExpHandler;
import com.hwijinrpg.event.PlayerJoinEventHandler;
import com.hwijinrpg.event.ServerTickHandler;
import com.hwijinrpg.network.handler.AbilityLevelUpHandler;
import com.hwijinrpg.network.handler.ChangeJobHandler;
import com.hwijinrpg.network.handler.PlayerInfoHandler;
import com.hwijinrpg.network.handler.ResetHandler;
import com.hwijinrpg.network.handler.SelectSkillHandler;
import com.hwijinrpg.network.handler.SkillLevelUpHandler;
import com.hwijinrpg.network.handler.UseSkillHandler;
import com.hwijinrpg.network.payload.RequestAbilityLevelUpPayload;
import com.hwijinrpg.network.payload.RequestChangeJobPayload;
import com.hwijinrpg.network.payload.RequestPlayerInfoPayload;
import com.hwijinrpg.network.payload.RequestResetPayload;
import com.hwijinrpg.network.payload.RequestSkillLevelUpPayload;
import com.hwijinrpg.network.payload.RpgPlayerInfoPayload;
import com.hwijinrpg.network.payload.SelectSkillPayload;
import com.hwijinrpg.network.payload.ServerDataPayload;
import com.hwijinrpg.network.payload.UseSkillPayload;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HwijinRpgMod
implements ModInitializer {
    public static final String MOD_ID = "hwijinrpg";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"hwijinrpg");

    public void onInitialize() {
        this.registerHandlers();
        this.registerPayloads();
        this.registerPacketReceivers();
        this.registerComponents();
    }

    private void registerHandlers() {
        EntityKillExpHandler.register();
        BlockBreakExpHandler.register();
        ServerTickHandler.register();
        PlayerJoinEventHandler.register();
    }

    private void registerPayloads() {
        PayloadTypeRegistry.playC2S().register(RequestPlayerInfoPayload.ID, RequestPlayerInfoPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestChangeJobPayload.ID, RequestChangeJobPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestResetPayload.ID, RequestResetPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestAbilityLevelUpPayload.ID, RequestAbilityLevelUpPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestSkillLevelUpPayload.ID, RequestSkillLevelUpPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(SelectSkillPayload.ID, SelectSkillPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(UseSkillPayload.ID, UseSkillPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(RpgPlayerInfoPayload.ID, RpgPlayerInfoPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(ServerDataPayload.ID, ServerDataPayload.CODEC);
    }

    private void registerPacketReceivers() {
        ServerPlayNetworking.registerGlobalReceiver(RequestPlayerInfoPayload.ID, (payload, context) -> PlayerInfoHandler.send(context.player()));
        ServerPlayNetworking.registerGlobalReceiver(RequestChangeJobPayload.ID, (payload, context) -> ChangeJobHandler.handle(payload, context.player()));
        ServerPlayNetworking.registerGlobalReceiver(RequestResetPayload.ID, (payload, context) -> ResetHandler.handle(payload, context.player()));
        ServerPlayNetworking.registerGlobalReceiver(RequestAbilityLevelUpPayload.ID, (payload, context) -> AbilityLevelUpHandler.handle(payload, context.player()));
        ServerPlayNetworking.registerGlobalReceiver(RequestSkillLevelUpPayload.ID, (payload, context) -> SkillLevelUpHandler.handle(payload, context.player()));
        ServerPlayNetworking.registerGlobalReceiver(SelectSkillPayload.ID, (payload, context) -> SelectSkillHandler.handle(payload, context.player()));
        ServerPlayNetworking.registerGlobalReceiver(UseSkillPayload.ID, (payload, context) -> UseSkillHandler.handle(payload, context.player()));
    }

    private void registerComponents() {
        Class<RpgComponents> ignore = RpgComponents.class;
    }
}

