/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.input;

import com.hwijinrpg.gui.RpgMainScreen;
import com.hwijinrpg.holder.PlayerDataHolder;
import com.hwijinrpg.network.payload.RequestPlayerInfoPayload;
import com.hwijinrpg.network.payload.SelectSkillPayload;
import com.hwijinrpg.skill.Skill;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class KeyBindingManager {
    public static final class_304 OPEN_PLAYER_GUI = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.hwijinrpg.open_gui", class_3675.class_307.field_1668, 293, "category.hwijinrpg"));
    public static final class_304 SELECT_SKILL = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.hwijinrpg.select_skill", class_3675.class_307.field_1668, 96, "category.hwijinrpg"));
    private static final boolean[] wasNumberPressed = new boolean[4];
    private static int lastSelectedSlot = 0;

    public static void register() {
        ClientTickEvents.START_CLIENT_TICK.register(client -> KeyBindingManager.handleLastSelectedSlot());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            KeyBindingManager.handleOpenPlayerGui();
            KeyBindingManager.handleSelectSkill();
        });
    }

    private static void handleOpenPlayerGui() {
        if (OPEN_PLAYER_GUI.method_1436()) {
            ClientPlayNetworking.send((class_8710)new RequestPlayerInfoPayload());
            class_310.method_1551().method_1507((class_437)new RpgMainScreen(class_310.method_1551().field_1755));
        }
    }

    private static void handleLastSelectedSlot() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        boolean isSelectSkillKeyPressed = SELECT_SKILL.method_1434();
        for (int i = 0; i < 4; ++i) {
            class_304 numberKey = client.field_1690.field_1852[i];
            boolean isNumberPressed = numberKey.method_1434();
            if (!isSelectSkillKeyPressed || !isNumberPressed) continue;
            lastSelectedSlot = client.field_1724.method_31548().field_7545;
        }
    }

    private static void handleSelectSkill() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return;
        }
        boolean isSelectSkillKeyPressed = SELECT_SKILL.method_1434();
        for (int i = 0; i < 4; ++i) {
            class_304 numberKey = client.field_1690.field_1852[i];
            boolean isNumberPressed = numberKey.method_1434();
            if (isSelectSkillKeyPressed && isNumberPressed && !wasNumberPressed[i]) {
                KeyBindingManager.selectSkill(i);
                client.field_1724.field_7512.method_7623();
                client.field_1724.field_7498.method_37420();
                client.field_1724.method_31548().field_7545 = lastSelectedSlot;
            }
            KeyBindingManager.wasNumberPressed[i] = isNumberPressed;
        }
    }

    private static void selectSkill(int skillIndex) {
        if (class_310.method_1551().field_1724 != null) {
            List<Map.Entry> skills = PlayerDataHolder.skills.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((Skill)entry.getKey()).getSort())).toList();
            if (skillIndex < 0 || skillIndex >= skills.size() || (Integer)skills.get(skillIndex).getValue() <= 0) {
                return;
            }
            ClientPlayNetworking.send((class_8710)new SelectSkillPayload((Skill)skills.get(skillIndex).getKey()));
        }
    }
}

