/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.component.RpgComponents;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.enchantment.ModEnchantments;
import com.hwijinrpg.network.handler.PlayerInfoHandler;
import com.hwijinrpg.skill.AbstractSkillContext;
import com.hwijinrpg.skill.Skill;
import com.hwijinrpg.skill.archer.arrowrain.ArrowRainDto;
import com.hwijinrpg.skill.archer.arrowrain.ArrowRainTracker;
import com.hwijinrpg.util.DurabilityUtils;
import com.hwijinrpg.util.EnchantmentUtil;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1667;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSkillHandler {
    protected abstract Skill getSkill();

    protected void useSkill(class_3222 player, PlayerRpgComponent comp, AbstractSkillContext context) {
        throw new RuntimeException("Not implemented");
    }

    protected void useSkill(class_3222 player, PlayerRpgComponent comp, AbstractSkillContext context, class_1667 arrow) {
        throw new RuntimeException("Not implemented");
    }

    public void handle(class_3222 player) {
        this.handle(player, null);
    }

    public void handle(class_3222 player, @Nullable class_1667 arrow) {
        PlayerRpgComponent comp = this.getComponent(player);
        AbstractSkillContext context = this.getSkillContext(comp);
        if (!this.validate(context, comp, arrow)) {
            return;
        }
        this.setCoolTime(player, context, comp);
        PlayerInfoHandler.send(player);
        if (arrow == null) {
            this.playAnimation(player);
            this.useSkill(player, comp, context);
        } else {
            this.useSkill(player, comp, context, arrow);
        }
        AbstractSkillHandler.reduceDurability(player, player.method_31548().method_7391());
    }

    protected void playAnimation(class_3222 player) {
        player.method_23667(class_1268.field_5808, true);
    }

    protected AbstractSkillContext getSkillContext(PlayerRpgComponent comp) {
        Integer skillLevel = comp.getSkills().get(this.getSkill());
        if (skillLevel <= 0) {
            return null;
        }
        return SkillContextsByLevelConfig.getInstance().getSkillContext(this.getSkill(), skillLevel, TypeToken.of(this.getSkill().getSkillContextClass()).getType());
    }

    protected PlayerRpgComponent getComponent(class_3222 player) {
        return (PlayerRpgComponent)RpgComponents.getPlayerRpgKey().get((Object)player);
    }

    protected boolean validate(AbstractSkillContext context, PlayerRpgComponent comp, class_1667 arrow) {
        return Objects.nonNull(context) && comp.isNotCoolTime(this.getSkill()) && (comp.getCurrentSkill() != Skill.ARROW_RAIN || ArrowRainTracker.firedArrows.values().stream().map(ArrowRainDto::getRainedArrows).flatMap(Collection::stream).noneMatch(rainedArrow -> Objects.equals(arrow.method_5667(), rainedArrow.method_5667())));
    }

    private void setCoolTime(class_3222 player, AbstractSkillContext context, PlayerRpgComponent comp) {
        int reduceSkillCoolTimeEnchantmentLevel = EnchantmentUtil.getLevel(player.method_6047(), ModEnchantments.REDUCE_SKILL_COOL_TIME);
        comp.getSkillCoolTimeByTicks().put(this.getSkill(), (int)(20.0 * context.getCoolTimeSeconds() * (1.0 - (double)reduceSkillCoolTimeEnchantmentLevel * 0.05)));
    }

    private static void reduceDurability(class_3222 player, class_1799 item) {
        DurabilityUtils.reduceDurability((class_1657)player, item, 1);
    }
}

