/*
 * Decompiled with CFR 0.152.
 */
package com.hwijinrpg.skill.mage.energyorb;

import com.google.common.reflect.TypeToken;
import com.hwijinrpg.component.PlayerRpgComponent;
import com.hwijinrpg.config.SkillContextsByLevelConfig;
import com.hwijinrpg.skill.Skill;
import com.hwijinrpg.skill.SkillTracker;
import com.hwijinrpg.skill.mage.energyorb.EnergyOrbDto;
import com.hwijinrpg.skill.mage.energyorb.EnergyOrbSkillContext;
import com.hwijinrpg.util.DamageUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_6880;

public class EnergyOrbTracker
extends SkillTracker {
    private static final Map<UUID, EnergyOrbDto> ticks = new HashMap<UUID, EnergyOrbDto>();

    public static void start(class_3222 player, EnergyOrbSkillContext context) {
        ticks.put(player.method_5667(), new EnergyOrbDto(context));
    }

    public static void tick(class_1937 world, class_3222 player, PlayerRpgComponent comp) {
        EnergyOrbSkillContext context = (EnergyOrbSkillContext)SkillContextsByLevelConfig.getInstance().getSkillContext(Skill.ENERGY_ORB, comp.getSkills().get(Skill.ENERGY_ORB), new TypeToken<EnergyOrbSkillContext>(){}.getType());
        EnergyOrbDto dto = ticks.get(player.method_5667());
        if (dto == null || context == null) {
            return;
        }
        if (dto.getTickPassed() < 2) {
            dto.incrementTick();
            return;
        }
        if (dto.getTickPassed() == 2) {
            dto.initCenterAndDirection((class_1657)player);
            world.method_43128(null, dto.getCenter().method_10216(), dto.getCenter().method_10214(), dto.getCenter().method_10215(), class_3417.field_14970, class_3419.field_15248, 0.8f, 1.5f);
        }
        if (dto.getTickPassed() >= 2) {
            EnergyOrbTracker.drawSphereAndDamage((class_1657)player, dto, context);
            if (dto.getTickPassed() >= 100) {
                EnergyOrbTracker.explode((class_1657)player, dto.getCenter(), context);
            } else {
                dto.incrementTick();
            }
        }
    }

    private static void drawSphereAndDamage(class_1657 player, EnergyOrbDto dto, EnergyOrbSkillContext context) {
        class_1937 world = player.method_37908();
        class_243 center = dto.getCenter();
        double hitRadius = (double)context.getRadius() - 0.01;
        class_238 hitBox = new class_238(center.method_1023(hitRadius, hitRadius, hitRadius), center.method_1031(hitRadius, hitRadius, hitRadius));
        boolean hitEntityExists = world.method_8390(class_1309.class, hitBox, e -> EnergyOrbTracker.isDamageableEntity((class_1309)player, e)).stream().findAny().isPresent();
        boolean isInsideBlock = world.method_8320(class_2338.method_49638((class_2374)center)).method_26212((class_1922)world, class_2338.method_49638((class_2374)dto.getCenter()));
        if (hitEntityExists || isInsideBlock) {
            EnergyOrbTracker.explode(player, center, context);
            return;
        }
        int density = 20 + (int)(context.getRadius() * 5.0f);
        ((class_3218)world).method_14199((class_2394)class_2398.field_29644, center.field_1352, center.field_1351, center.field_1350, (int)(context.getRadius() * 20.0f), 0.02, 0.02, 0.02, 0.2);
        ((class_3218)world).method_14199((class_2394)class_2398.field_11241, center.field_1352, center.field_1351, center.field_1350, (int)(context.getRadius() * 6.0f), 0.1, 0.1, 0.1, 0.05);
        for (int theta = 0; theta < 360; theta += 360 / density) {
            for (int phi = 0; phi < 360; phi += 360 / density) {
                double thetaRad = Math.toRadians(theta);
                double phiRad = Math.toRadians(phi);
                float effectRadius = context.getRadius() / 2.0f;
                double x = center.method_10216() + (double)effectRadius * Math.sin(thetaRad) * Math.cos(phiRad);
                double y = center.method_10214() + (double)effectRadius * Math.sin(thetaRad) * Math.sin(phiRad);
                double z = center.method_10215() + (double)effectRadius * Math.cos(thetaRad);
                ((class_3218)world).method_14199((class_2394)class_2398.field_11238, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static void explode(class_1657 player, class_243 center, EnergyOrbSkillContext context) {
        class_3218 world = (class_3218)player.method_37908();
        world.method_14199((class_2394)class_2398.field_22246, center.field_1352, center.field_1351, center.field_1350, (int)(context.getRadius() * 5.0f), 0.2, 0.2, 0.2, 0.2);
        world.method_14199((class_2394)class_2398.field_11236, center.field_1352, center.field_1351, center.field_1350, (int)(context.getRadius() * 2.0f), 0.2, 0.2, 0.2, 0.01);
        world.method_60511(null, center.field_1352, center.field_1351, center.field_1350, (class_6880)class_3417.field_15152, class_3419.field_15248, 1.0f, 1.8f);
        class_238 damageBox = new class_238(center.method_1023((double)context.getRadius(), (double)context.getRadius(), (double)context.getRadius()), center.method_1031((double)context.getRadius(), (double)context.getRadius(), (double)context.getRadius()));
        for (class_1309 target : world.method_8390(class_1309.class, damageBox, e -> EnergyOrbTracker.isDamageableEntity((class_1309)player, e))) {
            DamageUtil.damageTargetWithElement(player, target, context.getDamage());
            target.method_60491(target.method_19538().method_1020(center).method_1029().method_1021(0.5));
        }
        ticks.remove(player.method_5667());
    }
}

