/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfigCommon;
import org.cyclops.cyclopscore.init.IModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;

public class BlockMenrilWoodStrippedConfig
extends BlockConfigCommon<IntegratedDynamics> {
    public BlockMenrilWoodStrippedConfig() {
        super((IModBase)IntegratedDynamics._instance, "menril_wood_stripped", (eConfig, properties) -> new RotatedPillarBlock(properties.mapColor(MapColor.COLOR_CYAN).strength(2.0f).sound(SoundType.WOOD)){

            public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 5;
            }

            public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
                return 20;
            }
        }, BlockMenrilWoodStrippedConfig.getDefaultItemConstructor((IModBase)IntegratedDynamics._instance));
        NeoForge.EVENT_BUS.addListener(BlockMenrilWoodStrippedConfig::toolActionEvent);
    }

    public static void toolActionEvent(BlockEvent.BlockToolModificationEvent event) {
        if (event.getItemAbility() == ItemAbilities.AXE_STRIP && event.getState().getBlock() == RegistryEntries.BLOCK_MENRIL_WOOD.get()) {
            BlockState blockStateNew = ((Block)RegistryEntries.BLOCK_MENRIL_WOOD_STRIPPED.get()).defaultBlockState();
            for (Property property : event.getState().getProperties()) {
                if (!blockStateNew.hasProperty(property)) continue;
                blockStateNew = (BlockState)blockStateNew.setValue(property, event.getState().getValue(property));
            }
            event.setFinalState(blockStateNew);
        }
    }
}

