/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.core.part.PartTypeConfigurable;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public abstract class PartTypeAspects<P extends IPartType<P, S>, S extends IPartState<P>>
extends PartTypeConfigurable<P, S> {
    public PartTypeAspects(String name, PartRenderPosition partRenderPosition) {
        super(name, partRenderPosition);
    }

    public Set<IAspect> getAspects() {
        return Aspects.REGISTRY.getAspects(this);
    }

    @Override
    public boolean isUpdate(S state) {
        return !this.getAspects().isEmpty() || super.isUpdate(state);
    }

    @Override
    public int getConsumptionRate(S state) {
        return 1;
    }

    @Override
    public void loadTooltip(ItemStack itemStack, Consumer<Component> tooltipAdder) {
        super.loadTooltip(itemStack, tooltipAdder);
        if (this.getAspects().isEmpty()) {
            tooltipAdder.accept((Component)Component.translatable((String)"parttype.integrateddynamics.tooltip.noaspects").withStyle(ChatFormatting.GOLD));
        }
    }
}

