/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import com.google.common.collect.Lists;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.blockentity.BlockEntityEnergyBattery;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeIngredients;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeRecipe;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeDouble;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class GameTestsAspectsReadMachine {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsWorkerFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISWORKER, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsWorkerTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISWORKER, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineHasWorkFalseInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_HASWORK, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineHasWorkFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_HASWORK, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineHasWorkTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        FurnaceBlockEntity machine = (FurnaceBlockEntity)helper.getBlockEntity(POS.west(), FurnaceBlockEntity.class);
        machine.setItem(0, new ItemStack((ItemLike)Items.RAW_IRON));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_HASWORK, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineCanWorkFalseInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_CANWORK, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineCanWorkFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_CANWORK, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineCanWorkTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        FurnaceBlockEntity machine = (FurnaceBlockEntity)helper.getBlockEntity(POS.west(), FurnaceBlockEntity.class);
        machine.setItem(1, new ItemStack((ItemLike)Items.COAL));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_CANWORK, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsWorkingFalseInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISWORKING, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsWorkingFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISWORKING, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsWorkingTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        FurnaceBlockEntity machine = (FurnaceBlockEntity)helper.getBlockEntity(POS.west(), FurnaceBlockEntity.class);
        machine.setItem(0, new ItemStack((ItemLike)Items.RAW_IRON));
        machine.setItem(1, new ItemStack((ItemLike)Items.COAL));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISWORKING, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsTemperatureFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISTEMPERATURE, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsTemperatureTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISTEMPERATURE, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineTemperatureInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.DOUBLE_TEMPERATURE, ValueTypeDouble.ValueDouble.of(0.0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineTemperature(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        FurnaceBlockEntity machine = (FurnaceBlockEntity)helper.getBlockEntity(POS.west(), FurnaceBlockEntity.class);
        machine.setItem(0, new ItemStack((ItemLike)Items.RAW_IRON));
        machine.setItem(1, new ItemStack((ItemLike)Items.COAL));
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.DOUBLE_TEMPERATURE, ValueTypeDouble.ValueDouble.of(1873.15));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineTemperatureWorking(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.DOUBLE_TEMPERATURE, ValueTypeDouble.ValueDouble.of(273.15));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineMaxTemperatureInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.DOUBLE_MAXTEMPERATURE, ValueTypeDouble.ValueDouble.of(0.0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineMaxTemperature(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.DOUBLE_MAXTEMPERATURE, ValueTypeDouble.ValueDouble.of(Double.MAX_VALUE));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineMinTemperatureInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.DOUBLE_MINTEMPERATURE, ValueTypeDouble.ValueDouble.of(0.0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineMinTemperature(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.DOUBLE_MINTEMPERATURE, ValueTypeDouble.ValueDouble.of(273.15));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineDefaultTemperatureInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.DOUBLE_DEFAULTTEMPERATURE, ValueTypeDouble.ValueDouble.of(0.0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineDefaultTemperature(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.DOUBLE_DEFAULTTEMPERATURE, ValueTypeDouble.ValueDouble.of(273.15));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsRecipeHandlerFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISRECIPEHANDLER, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsRecipeHandlerTrue(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISRECIPEHANDLER, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineRecipesInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.LIST_GETRECIPES, ValueTypeList.ValueList.ofAll((IValue[])new IValue[0]));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineRecipes(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        GameTestHelpersIntegratedDynamics.testReadAspectPredicate(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.LIST_GETRECIPES, list -> {
            try {
                return list.getRawValue().getLength() > 10;
            }
            catch (EvaluationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineGetRecipeOutputInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspectOperator(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.OPERATOR_GETRECIPEOUTPUT, Lists.newArrayList((Object[])new IValue[]{ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)MixedIngredients.ofInstance((IngredientComponent)IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.RAW_IRON)))}), ValueObjectTypeIngredients.ValueIngredients.of(null));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineGetRecipeOutput(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        MixedIngredients ingredients = MixedIngredients.ofInstance((IngredientComponent)IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.RAW_IRON));
        GameTestHelpersIntegratedDynamics.testReadAspectOperator(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.OPERATOR_GETRECIPEOUTPUT, Lists.newArrayList((Object[])new IValue[]{ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)ingredients)}), ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)MixedIngredients.ofInstance((IngredientComponent)IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.IRON_INGOT))));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineGetRecipeInputsInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspectOperator(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.OPERATOR_GETRECIPEINPUTS, Lists.newArrayList((Object[])new IValue[]{ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)MixedIngredients.ofInstance((IngredientComponent)IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.IRON_INGOT)))}), ValueTypeList.ValueList.ofAll((IValue[])new IValue[0]));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineGetRecipeInputs(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        MixedIngredients ingredients = MixedIngredients.ofInstance((IngredientComponent)IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.IRON_INGOT));
        GameTestHelpersIntegratedDynamics.testReadAspectOperatorPredicate(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.OPERATOR_GETRECIPEINPUTS, Lists.newArrayList((Object[])new IValue[]{ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)ingredients)}), value -> {
            try {
                ValueTypeList.ValueList list;
                return value instanceof ValueTypeList.ValueList && (list = (ValueTypeList.ValueList)value).getRawValue().getLength() >= 3;
            }
            catch (EvaluationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineGetRecipesByInputsInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspectOperator(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.OPERATOR_GETRECIPESBYINPUT, Lists.newArrayList((Object[])new IValue[]{ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)MixedIngredients.ofInstance((IngredientComponent)IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.RAW_IRON)))}), ValueTypeList.ValueList.ofAll((IValue[])new IValue[0]));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineGetRecipesByInputsInputs(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        MixedIngredients ingredients = MixedIngredients.ofInstance((IngredientComponent)IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.RAW_IRON));
        GameTestHelpersIntegratedDynamics.testReadAspectOperatorPredicate(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.OPERATOR_GETRECIPESBYINPUT, Lists.newArrayList((Object[])new IValue[]{ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)ingredients)}), value -> {
            try {
                ValueTypeList.ValueList list;
                return value instanceof ValueTypeList.ValueList && (list = (ValueTypeList.ValueList)value).getRawValue().getLength() == 1;
            }
            catch (EvaluationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineGetRecipesByOutputInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspectOperator(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.OPERATOR_GETRECIPESBYOUTPUT, Lists.newArrayList((Object[])new IValue[]{ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)MixedIngredients.ofInstance((IngredientComponent)IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.IRON_INGOT)))}), ValueTypeList.ValueList.ofAll((IValue[])new IValue[0]));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineGetRecipesByOutput(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        MixedIngredients ingredients = MixedIngredients.ofInstance((IngredientComponent)IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.IRON_INGOT));
        GameTestHelpersIntegratedDynamics.testReadAspectOperatorPredicate(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.OPERATOR_GETRECIPESBYOUTPUT, Lists.newArrayList((Object[])new IValue[]{ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)ingredients)}), value -> {
            try {
                ValueTypeList.ValueList list;
                return value instanceof ValueTypeList.ValueList && (list = (ValueTypeList.ValueList)value).getRawValue().getLength() == 3;
            }
            catch (EvaluationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineGetRecipeByInputsInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspectOperator(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.OPERATOR_GETRECIPEBYINPUT, Lists.newArrayList((Object[])new IValue[]{ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)MixedIngredients.ofInstance((IngredientComponent)IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.RAW_IRON)))}), ValueObjectTypeRecipe.ValueRecipe.of(null));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineGetRecipeByInputsInputs(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        MixedIngredients ingredients = MixedIngredients.ofInstance((IngredientComponent)IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.RAW_IRON));
        GameTestHelpersIntegratedDynamics.testReadAspectOperatorPredicate(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.OPERATOR_GETRECIPEBYINPUT, Lists.newArrayList((Object[])new IValue[]{ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)ingredients)}), value -> {
            ValueObjectTypeRecipe.ValueRecipe recipe;
            return value instanceof ValueObjectTypeRecipe.ValueRecipe && (recipe = (ValueObjectTypeRecipe.ValueRecipe)value).getRawValue().isPresent();
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineGetRecipeByOutputInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspectOperator(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.OPERATOR_GETRECIPEBYOUTPUT, Lists.newArrayList((Object[])new IValue[]{ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)MixedIngredients.ofInstance((IngredientComponent)IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.IRON_INGOT)))}), ValueObjectTypeRecipe.ValueRecipe.of(null));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineGetRecipeByOutput(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.FURNACE);
        MixedIngredients ingredients = MixedIngredients.ofInstance((IngredientComponent)IngredientComponents.ITEMSTACK, (Object)new ItemStack((ItemLike)Items.IRON_INGOT));
        GameTestHelpersIntegratedDynamics.testReadAspectOperatorPredicate(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.OPERATOR_GETRECIPEBYOUTPUT, Lists.newArrayList((Object[])new IValue[]{ValueObjectTypeIngredients.ValueIngredients.of((IMixedIngredients)ingredients)}), value -> {
            ValueObjectTypeRecipe.ValueRecipe recipe;
            return value instanceof ValueObjectTypeRecipe.ValueRecipe && (recipe = (ValueObjectTypeRecipe.ValueRecipe)value).getRawValue().isPresent();
        });
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGY, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGY, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyReceiverInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGYRECEIVER, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyReceiverValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGYRECEIVER, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyProviderInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGYPROVIDER, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyProviderValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGYPROVIDER, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineCanExtractEnergyInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_CANEXTRACTENERGY, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineCanExtractEnergyValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        BlockEntityEnergyBattery battery = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.west(), BlockEntityEnergyBattery.class);
        battery.setEnergyStored(100);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_CANEXTRACTENERGY, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineCanExtractEnergyValidFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        BlockEntityEnergyBattery battery = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.west(), BlockEntityEnergyBattery.class);
        battery.setEnergyStored(0);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_CANEXTRACTENERGY, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineCanInsertEnergyInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_CANINSERTENERGY, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineCanInsertEnergyValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_CANINSERTENERGY, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyFullInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGYFULL, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyFullValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        BlockEntityEnergyBattery battery = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.west(), BlockEntityEnergyBattery.class);
        battery.setEnergyStored(1000000);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGYFULL, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyFullValidFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        BlockEntityEnergyBattery battery = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.west(), BlockEntityEnergyBattery.class);
        battery.setEnergyStored(100);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGYFULL, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyEmptyInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGYEMPTY, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyEmptyValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        BlockEntityEnergyBattery battery = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.west(), BlockEntityEnergyBattery.class);
        battery.setEnergyStored(0);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGYEMPTY, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyEmptyValidFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        BlockEntityEnergyBattery battery = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.west(), BlockEntityEnergyBattery.class);
        battery.setEnergyStored(100);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGYEMPTY, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyNonEmptyInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGYNONEMPTY, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyNonEmptyValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        BlockEntityEnergyBattery battery = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.west(), BlockEntityEnergyBattery.class);
        battery.setEnergyStored(100);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGYNONEMPTY, ValueTypeBoolean.ValueBoolean.of(true));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineIsEnergyNonEmptyValidFalse(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        BlockEntityEnergyBattery battery = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.west(), BlockEntityEnergyBattery.class);
        battery.setEnergyStored(0);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.BOOLEAN_ISENERGYNONEMPTY, ValueTypeBoolean.ValueBoolean.of(false));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineEnergyStoredInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.INTEGER_ENERGYSTORED, ValueTypeInteger.ValueInteger.of(0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineEnergyStoredValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        BlockEntityEnergyBattery battery = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.west(), BlockEntityEnergyBattery.class);
        battery.setEnergyStored(100);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.INTEGER_ENERGYSTORED, ValueTypeInteger.ValueInteger.of(100));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineEnergyCapacityInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.INTEGER_ENERGYCAPACITY, ValueTypeInteger.ValueInteger.of(0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineEnergyCapacityValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        BlockEntityEnergyBattery battery = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.west(), BlockEntityEnergyBattery.class);
        battery.setEnergyStored(100);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.INTEGER_ENERGYCAPACITY, ValueTypeInteger.ValueInteger.of(1000000));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineEnergyFillRatioInvalid(GameTestHelper helper) {
        helper.setBlock(POS.west(), Blocks.STONE);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.DOUBLE_ENERGYFILLRATIO, ValueTypeDouble.ValueDouble.of(0.0));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsReadMachineEnergyFillRatioValid(GameTestHelper helper) {
        helper.setBlock(POS.west(), (Block)RegistryEntries.BLOCK_ENERGY_BATTERY.get());
        BlockEntityEnergyBattery battery = (BlockEntityEnergyBattery)helper.getBlockEntity(POS.west(), BlockEntityEnergyBattery.class);
        battery.setEnergyStored(500000);
        GameTestHelpersIntegratedDynamics.testReadAspect(POS, helper, PartTypes.MACHINE_READER, Aspects.Read.Machine.DOUBLE_ENERGYFILLRATIO, ValueTypeDouble.ValueDouble.of(0.5));
    }
}

