/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.blockentity.BlockEntityVariablestore;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.part.PartTypes;
import org.cyclops.integrateddynamics.gametest.GameTestHelpersIntegratedDynamics;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class GameTestsAspectsWriteRedstone {
    public static final String TEMPLATE_EMPTY = "integrateddynamics:empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 0, 2);

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsWriteRedstoneBooleanTrue(GameTestHelper helper) {
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        GameTestHelpersIntegratedDynamics.testWriteAspectSetup(POS, helper, PartTypes.REDSTONE_WRITER, Aspects.Write.Redstone.BOOLEAN, ValueTypeBoolean.ValueBoolean.of(true));
        helper.succeedWhen(() -> helper.assertBlockProperty(POS.west(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(15)));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsWriteRedstoneBooleanFalse(GameTestHelper helper) {
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        GameTestHelpersIntegratedDynamics.testWriteAspectSetup(POS, helper, PartTypes.REDSTONE_WRITER, Aspects.Write.Redstone.BOOLEAN, ValueTypeBoolean.ValueBoolean.of(false));
        helper.succeedWhen(() -> helper.assertBlockProperty(POS.west(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(0)));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsWriteRedstoneInteger(GameTestHelper helper) {
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        GameTestHelpersIntegratedDynamics.testWriteAspectSetup(POS, helper, PartTypes.REDSTONE_WRITER, Aspects.Write.Redstone.INTEGER, ValueTypeInteger.ValueInteger.of(10));
        helper.succeedWhen(() -> helper.assertBlockProperty(POS.west(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(10)));
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsWriteRedstoneBooleanPulse(GameTestHelper helper) {
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.EAST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        GameTestHelpersIntegratedDynamics.testWriteAspectSetup(POS, helper, PartTypes.REDSTONE_WRITER, Aspects.Write.Redstone.BOOLEAN_PULSE, GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.EAST), Aspects.Read.Redstone.BOOLEAN_CLOCK));
        helper.startSequence().thenWaitUntil(() -> helper.assertBlockProperty(POS.west(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(0))).thenWaitUntil(() -> helper.assertBlockProperty(POS.west(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(15))).thenWaitUntil(() -> helper.assertBlockProperty(POS.west(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(0))).thenSucceed();
    }

    @GameTest(template="integrateddynamics:empty10")
    public void testAspectsWriteRedstoneIntegerPulse(GameTestHelper helper) {
        helper.setBlock(POS.west().below(), Blocks.STONE);
        helper.setBlock(POS.west(), Blocks.REDSTONE_WIRE);
        helper.setBlock(POS, (Block)RegistryEntries.BLOCK_CABLE.value());
        PartHelpers.addPart((Level)helper.getLevel(), helper.absolutePos(POS), Direction.EAST, (IPartType)PartTypes.REDSTONE_READER, new ItemStack((ItemLike)PartTypes.REDSTONE_READER.getItem()));
        helper.setBlock(POS.north(), (Block)RegistryEntries.BLOCK_VARIABLE_STORE.get());
        BlockEntityVariablestore variableStore = (BlockEntityVariablestore)helper.getBlockEntity(POS.north(), BlockEntityVariablestore.class);
        ItemStack variableClock = GameTestHelpersIntegratedDynamics.createVariableFromReader((Level)helper.getLevel(), PartPos.of((Level)helper.getLevel(), helper.absolutePos(POS), Direction.EAST), Aspects.Read.Redstone.BOOLEAN_CLOCK);
        variableStore.getInventory().setItem(0, variableClock);
        ItemStack variable1 = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of(0));
        ItemStack variable2 = GameTestHelpersIntegratedDynamics.createVariableForValue((Level)helper.getLevel(), ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of(3));
        variableStore.getInventory().setItem(1, variable1);
        variableStore.getInventory().setItem(2, variable2);
        ItemStack variableChoice = GameTestHelpersIntegratedDynamics.createVariableForOperator((Level)helper.getLevel(), Operators.GENERAL_CHOICE, new int[]{GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variableClock).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variable1).getId(), GameTestHelpersIntegratedDynamics.getVariableFacade((Level)helper.getLevel(), variable2).getId()});
        GameTestHelpersIntegratedDynamics.testWriteAspectSetup(POS, helper, PartTypes.REDSTONE_WRITER, Aspects.Write.Redstone.INTEGER_PULSE, variableChoice);
        helper.startSequence().thenWaitUntil(() -> helper.assertBlockProperty(POS.west(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(0))).thenWaitUntil(() -> helper.assertBlockProperty(POS.west(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(15))).thenWaitUntil(() -> helper.assertBlockProperty(POS.west(), (Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(0))).thenSucceed();
    }
}

