/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.gametest.integration;

import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.core.evaluate.operator.Operators;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBlock;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeFluidStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeItemStack;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeInteger;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeNbt;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeString;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.test.IntegrationBefore;
import org.cyclops.integrateddynamics.core.test.IntegrationTest;
import org.cyclops.integrateddynamics.core.test.TestHelpers;
import org.cyclops.integrateddynamics.gametest.integration.Asserts;
import org.cyclops.integrateddynamics.gametest.integration.DummyValueType;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariable;
import org.cyclops.integrateddynamics.gametest.integration.DummyVariableFluidStack;

public class TestFluidStackOperators {
    private static final DummyValueType DUMMY_TYPE = DummyValueType.TYPE;
    private static final DummyVariable<DummyValueType.DummyValue> DUMMY_VARIABLE = new DummyVariable<DummyValueType.DummyValue>(DUMMY_TYPE, DummyValueType.DummyValue.of());
    private DummyVariableFluidStack eBucketLava;
    private DummyVariableFluidStack eBucketWater;
    private DummyVariableFluidStack eBucketEmpty;
    private DummyVariableFluidStack eWater100;
    private DummyVariableFluidStack eWater100Tag;
    private DummyVariable<ValueTypeInteger.ValueInteger> i99;
    private DummyVariable<ValueTypeString.ValueString> sDamage;
    private DummyVariable<ValueTypeNbt.ValueNbt> t4;
    private DummyVariable<ValueTypeString.ValueString> sWater;

    @IntegrationBefore
    public void before() {
        this.eBucketLava = new DummyVariableFluidStack(ValueObjectTypeFluidStack.ValueFluidStack.of(new FluidStack((Fluid)Fluids.LAVA, IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume())));
        this.eBucketWater = new DummyVariableFluidStack(ValueObjectTypeFluidStack.ValueFluidStack.of(new FluidStack((Fluid)Fluids.WATER, IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume())));
        this.eBucketEmpty = new DummyVariableFluidStack(ValueObjectTypeFluidStack.ValueFluidStack.of(FluidStack.EMPTY));
        this.eWater100 = new DummyVariableFluidStack(ValueObjectTypeFluidStack.ValueFluidStack.of(new FluidStack((Fluid)Fluids.WATER, 100)));
        this.eWater100Tag = new DummyVariableFluidStack(ValueObjectTypeFluidStack.ValueFluidStack.of(new FluidStack((Fluid)Fluids.WATER, 100)));
        ((ValueObjectTypeFluidStack.ValueFluidStack)this.eWater100Tag.getValue()).getRawValue().set(DataComponents.DAMAGE, (Object)3);
        this.i99 = new DummyVariable<ValueTypeInteger.ValueInteger>(ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of(99));
        this.sDamage = new DummyVariable<ValueTypeString.ValueString>(ValueTypes.STRING, ValueTypeString.ValueString.of("minecraft:damage"));
        this.t4 = new DummyVariable<ValueTypeNbt.ValueNbt>(ValueTypes.NBT, ValueTypeNbt.ValueNbt.of((Tag)IntTag.valueOf((int)4)));
        this.i99 = new DummyVariable<ValueTypeInteger.ValueInteger>(ValueTypes.INTEGER, ValueTypeInteger.ValueInteger.of(99));
        this.sWater = new DummyVariable<ValueTypeString.ValueString>(ValueTypes.STRING, ValueTypeString.ValueString.of("minecraft:water"));
        CompoundTag tag = new CompoundTag();
        tag.putInt("Damage", 51);
    }

    @IntegrationTest
    public void testAmount() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_AMOUNT.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume(), "amount(lava:1000) = 1000");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_AMOUNT.evaluate(this.eBucketWater);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume(), "amount(water:1000) = 1000");
        IValue res3 = Operators.OBJECT_FLUIDSTACK_AMOUNT.evaluate(this.eWater100);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res3).getRawValue(), 100, "amount(water:100) = 100");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeAmountLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_AMOUNT.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeAmountSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_AMOUNT.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeAmount() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_AMOUNT.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBlock() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_BLOCK.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueObjectTypeBlock.ValueBlock, "result is a block");
        TestHelpers.assertEqual((BlockState)((ValueObjectTypeBlock.ValueBlock)res1).getRawValue().get(), Blocks.LAVA.defaultBlockState(), "block(lava) = lava");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_BLOCK.evaluate(this.eBucketWater);
        TestHelpers.assertEqual((BlockState)((ValueObjectTypeBlock.ValueBlock)res2).getRawValue().get(), Blocks.WATER.defaultBlockState(), "block(water) = water");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBlockLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_BLOCK.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBlockSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_BLOCK.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeBlock() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_BLOCK.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testLightLevel() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_LIGHT_LEVEL.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 15, "lightLevel(lava) = 15");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_LIGHT_LEVEL.evaluate(this.eBucketWater);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 0, "lightLevel(water) = 0");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeLightLevelLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_LIGHT_LEVEL.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeLightLevelSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_LIGHT_LEVEL.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeLightLevel() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_LIGHT_LEVEL.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testDensity() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_DENSITY.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 3000, "density(lava) = 1000");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_DENSITY.evaluate(this.eBucketWater);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 1000, "density(water) = 1000");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeDensityLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_DENSITY.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeDensitySmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_DENSITY.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeDensity() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_DENSITY.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testTemperature() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_TEMPERATURE.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 1300, "temperature(lava) = 1300");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_TEMPERATURE.evaluate(this.eBucketWater);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 300, "temperature(water) = 300");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTemperatureLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_TEMPERATURE.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTemperatureSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_TEMPERATURE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeTemperature() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_TEMPERATURE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testViscosity() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_VISCOSITY.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueTypeInteger.ValueInteger, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res1).getRawValue(), 6000, "viscosity(lava) = 6000");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_VISCOSITY.evaluate(this.eBucketWater);
        TestHelpers.assertEqual(((ValueTypeInteger.ValueInteger)res2).getRawValue(), 1000, "viscosity(water) = 1000");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeViscosityLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_VISCOSITY.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeViscositySmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_VISCOSITY.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeViscosity() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_VISCOSITY.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testIsLighterThanAir() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_IS_LIGHTER_THAN_AIR.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "isgaseous(lava) = false");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_IS_LIGHTER_THAN_AIR.evaluate(this.eBucketWater);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), false, "isgaseous(water) = false");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsLighterThanAirLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_IS_LIGHTER_THAN_AIR.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsLighterThanAirSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_IS_LIGHTER_THAN_AIR.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsLighterThanAir() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_IS_LIGHTER_THAN_AIR.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testRarity() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_RARITY.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is an integer");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res1).getRawValue(), Rarity.COMMON.name(), "rarity(lava) = common");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_RARITY.evaluate(this.eBucketWater);
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res2).getRawValue(), Rarity.COMMON.name(), "rarity(water) = common");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeRarityLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_RARITY.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeRaritySmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_RARITY.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeRarity() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_RARITY.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testSoundBucketEmpty() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_SOUND_BUCKET_EMPTY.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res1).getRawValue(), SoundEvents.BUCKET_EMPTY_LAVA.location().toString(), "soundBucketEmpty(lava) = bucket_empty");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_SOUND_BUCKET_EMPTY.evaluate(this.eBucketWater);
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res2).getRawValue(), SoundEvents.BUCKET_EMPTY.location().toString(), "soundBucketEmpty(water) = bucket_empty");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeSoundBucketEmptyLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_SOUND_BUCKET_EMPTY.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeSoundBucketEmptySmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_SOUND_BUCKET_EMPTY.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeSoundBucketEmpty() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_SOUND_BUCKET_EMPTY.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testSoundBucketFill() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_SOUND_BUCKET_FILL.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res1).getRawValue(), SoundEvents.BUCKET_FILL_LAVA.location().toString(), "soundBucketFill(lava) = bucket_fill");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_SOUND_BUCKET_FILL.evaluate(this.eBucketWater);
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res2).getRawValue(), SoundEvents.BUCKET_FILL.location().toString(), "soundBucketFill(water) = bucket_fill");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeSoundBucketFillLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_SOUND_BUCKET_FILL.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeSoundBucketFillSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_SOUND_BUCKET_FILL.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeSoundBucketFill() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_SOUND_BUCKET_FILL.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testSoundFluidVaporize() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_SOUND_FLUID_VAPORIZE.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res1).getRawValue(), "", "soundFluidVaporize(lava) = ");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_SOUND_FLUID_VAPORIZE.evaluate(this.eBucketWater);
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res2).getRawValue(), SoundEvents.FIRE_EXTINGUISH.location().toString(), "soundFluidVaporize(water) = ");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeSoundFluidVaporizeLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_SOUND_FLUID_VAPORIZE.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeSoundFluidVaporizeSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_SOUND_FLUID_VAPORIZE.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeSoundFluidVaporize() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_SOUND_FLUID_VAPORIZE.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testBucket() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_BUCKET.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueObjectTypeItemStack.ValueItemStack, "result is an item");
        TestHelpers.assertEqual(((ValueObjectTypeItemStack.ValueItemStack)res1).getRawValue().getItem(), Items.LAVA_BUCKET, "bucket(lava) = bucket_lava");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_BUCKET.evaluate(this.eBucketWater);
        TestHelpers.assertEqual(((ValueObjectTypeItemStack.ValueItemStack)res2).getRawValue().getItem(), Items.WATER_BUCKET, "bucket(water) = bucket_water");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBucketLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_BUCKET.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeBucketSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_BUCKET.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeBucket() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_BUCKET.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testIsRawFluidEqual() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_ISRAWFLUIDEQUAL.evaluate(this.eBucketLava, this.eBucketWater);
        Asserts.check(res1 instanceof ValueTypeBoolean.ValueBoolean, "result is a boolean");
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res1).getRawValue(), false, "israwfluidequal(lava, water) = false");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_ISRAWFLUIDEQUAL.evaluate(this.eBucketLava, this.eBucketLava);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res2).getRawValue(), true, "israwfluidequal(lava:1000, lava:1000) = true");
        IValue res3 = Operators.OBJECT_FLUIDSTACK_ISRAWFLUIDEQUAL.evaluate(this.eBucketWater, this.eWater100);
        TestHelpers.assertEqual(((ValueTypeBoolean.ValueBoolean)res3).getRawValue(), true, "israwfluidequal(water:1000, water:100) = false");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsRawFluidEqualLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_ISRAWFLUIDEQUAL.evaluate(this.eBucketLava, this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeIsRawFluidEqualSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_ISRAWFLUIDEQUAL.evaluate(this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeIsRawFluidEqual() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_ISRAWFLUIDEQUAL.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testFluidModName() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_MODNAME.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueTypeString.ValueString, "result is a string");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)res1).getRawValue(), "Minecraft", "modname(lava) = Minecraft");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeModNameLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_MODNAME.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeModNameSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_MODNAME.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeModName() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_MODNAME.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testFluidNbt() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_DATA.evaluate(this.eBucketLava);
        Asserts.check(res1 instanceof ValueTypeNbt.ValueNbt, "result is an nbt tag");
        TestHelpers.assertEqual(((ValueTypeNbt.ValueNbt)res1).getRawValue().isPresent(), false, "data(lava) = null");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_DATA.evaluate(this.eWater100Tag);
        CompoundTag tag = new CompoundTag();
        tag.putInt("minecraft:damage", 3);
        TestHelpers.assertEqual((Tag)((ValueTypeNbt.ValueNbt)res2).getRawValue().get(), tag, "nbt(watertag) != null");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeNbtLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_DATA.evaluate(this.eBucketLava, this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeNbtSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_DATA.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeNbt() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_DATA.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testWithAmount() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_WITH_AMOUNT.evaluate(this.eBucketLava, this.i99);
        Asserts.check(res1 instanceof ValueObjectTypeFluidStack.ValueFluidStack, "result is an integer");
        TestHelpers.assertEqual(((ValueObjectTypeFluidStack.ValueFluidStack)res1).getRawValue().getFluid(), ((ValueObjectTypeFluidStack.ValueFluidStack)this.eBucketLava.getValue()).getRawValue().getFluid(), "withamount(lava, 99) = lava@99");
        TestHelpers.assertEqual(((ValueObjectTypeFluidStack.ValueFluidStack)res1).getRawValue().getAmount(), 99, "withamount(lava, 99) = lava@99");
        TestHelpers.assertEqual(((ValueObjectTypeFluidStack.ValueFluidStack)this.eBucketLava.getValue()).getRawValue().getAmount(), IModHelpersNeoForge.get().getFluidHelpers().getBucketVolume(), "original value is not changed");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeWithAmountLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_WITH_AMOUNT.evaluate(this.eBucketLava, this.i99, this.i99);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeWithAmountSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_WITH_AMOUNT.evaluate(this.eBucketLava);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeWithAmount() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_WITH_AMOUNT.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testFluidStackDataKeys() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_DATA_KEYS.evaluate(this.eWater100);
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res1).getRawValue().getLength(), 0, "datakeys(water) = []");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_DATA_KEYS.evaluate(this.eWater100Tag);
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res2).getRawValue().getLength(), 1, "datakeys(waterTag).length = 1");
        TestHelpers.assertEqual(((ValueTypeString.ValueString)((ValueTypeList.ValueList)res2).getRawValue().get(0)).getRawValue(), "minecraft:damage", "datakeys(waterTag)[0] == ...");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputDataKeysDataKeysLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_DATA_KEYS.evaluate(this.eWater100Tag, this.eWater100Tag);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputDataKeysDataKeysSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_DATA_KEYS.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeDataKeys() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_DATA_KEYS.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testFluidStackDataValue() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_DATA_VALUE.evaluate(this.eWater100, this.sDamage);
        Asserts.check(res1 instanceof ValueTypeNbt.ValueNbt, "result is an empty tag");
        TestHelpers.assertEqual(((ValueTypeNbt.ValueNbt)res1).getRawValue().isEmpty(), true, "datavalue(water, damage) = empty");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_DATA_VALUE.evaluate(this.eWater100Tag, this.sDamage);
        TestHelpers.assertEqual((Tag)((ValueTypeNbt.ValueNbt)res2).getRawValue().get(), IntTag.valueOf((int)3), "datavalue(waterTag, damage).length = 3");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputDataValueDataValueLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_DATA_VALUE.evaluate(this.eWater100Tag, this.sDamage, this.eWater100Tag);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputDataValueDataValueSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_DATA_VALUE.evaluate(this.eWater100Tag);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeDataValue() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_DATA_VALUE.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testFluidStackWithData() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_WITH_DATA.evaluate(this.eWater100, this.sDamage, this.t4);
        Asserts.check(res1 instanceof ValueObjectTypeFluidStack.ValueFluidStack, "result is an fluid");
        FluidStack outFluid1 = ((ValueObjectTypeFluidStack.ValueFluidStack)res1).getRawValue();
        TestHelpers.assertEqual(outFluid1.getFluid(), ((ValueObjectTypeFluidStack.ValueFluidStack)this.eWater100.getValue()).getRawValue().getFluid(), "withdata(water, damage, 4) = water");
        TestHelpers.assertNonEqual(outFluid1.getComponents(), ((ValueObjectTypeFluidStack.ValueFluidStack)this.eWater100.getValue()).getRawValue().getComponents(), "withdata(water, damage, 4) !=components water");
        TestHelpers.assertEqual((Integer)outFluid1.get(DataComponents.DAMAGE), 4, "withdata(water, damage, 4).damage = 4");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_WITH_DATA.evaluate(this.eWater100Tag, this.sDamage, this.t4);
        FluidStack outFluid2 = ((ValueObjectTypeFluidStack.ValueFluidStack)res2).getRawValue();
        TestHelpers.assertEqual(outFluid2.getFluid(), ((ValueObjectTypeFluidStack.ValueFluidStack)this.eWater100.getValue()).getRawValue().getFluid(), "withdata(waterTag, damage, 4) = water");
        TestHelpers.assertNonEqual(outFluid2.getComponents(), ((ValueObjectTypeFluidStack.ValueFluidStack)this.eWater100.getValue()).getRawValue().getComponents(), "withdata(waterTag, damage, 4) !=components water");
        TestHelpers.assertEqual((Integer)outFluid2.get(DataComponents.DAMAGE), 4, "withdata(waterTag, damage, 4).damage = 4");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputWithDataWithDataLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_WITH_DATA.evaluate(this.eWater100Tag, this.sDamage, this.t4, this.eWater100Tag);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputWithDataWithDataSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_WITH_DATA.evaluate(this.eWater100Tag, this.sDamage);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeWithData() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_WITH_DATA.evaluate(DUMMY_VARIABLE, DUMMY_VARIABLE, DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testFluidStackTag() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_TAG.evaluate(this.eBucketWater);
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res1).getRawValue().getLength(), 2, "size(tag(water)) = 2");
        IValue res2 = Operators.OBJECT_FLUIDSTACK_TAG.evaluate(this.eBucketEmpty);
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res2).getRawValue().getLength(), 0, "size(tag(empty)) = 0");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_TAG.evaluate(this.eBucketWater, this.eBucketWater);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_TAG.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeTag() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_TAG.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testFluidStackTagStacks() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_TAG_STACKS.evaluate(this.sWater);
        Asserts.check(res1 instanceof ValueTypeList.ValueList, "result is a list");
        TestHelpers.assertEqual(((ValueTypeList.ValueList)res1).getRawValue().getLength(), (int)Helpers.getFluidTagValues("minecraft:water").count(), "size(tag_stacks(water))");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagStacksLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_TAG_STACKS.evaluate(this.sWater, this.sWater);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeTagStacksSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_TAG_STACKS.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeTagStacks() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_TAG_STACKS.evaluate(DUMMY_VARIABLE);
    }

    @IntegrationTest
    public void testFluidFluidByName() throws EvaluationException {
        IValue res1 = Operators.OBJECT_FLUIDSTACK_BY_NAME.evaluate(this.sWater);
        Asserts.check(res1 instanceof ValueObjectTypeFluidStack.ValueFluidStack, "result is a fluid");
        TestHelpers.assertEqual(((ValueObjectTypeFluidStack.ValueFluidStack)res1).getRawValue().getFluid(), new FluidStack((Fluid)Fluids.WATER, 1000).getFluid(), "fluidbyname(minecraft:water) = water");
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeFluidByNameLarge() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_BY_NAME.evaluate(this.sWater, this.sWater);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputSizeFluidByNameSmall() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_BY_NAME.evaluate(new IVariable[0]);
    }

    @IntegrationTest(expected=EvaluationException.class)
    public void testInvalidInputTypeFluidByName() throws EvaluationException {
        Operators.OBJECT_FLUIDSTACK_BY_NAME.evaluate(DUMMY_VARIABLE);
    }
}

