/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.cyclops.cyclopscore.blockentity.IBlockEntityDelayedTickable;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTProviderComponent;

public class CyclopsBlockEntity
extends BlockEntity
implements INBTProvider,
IDirtyMarkListener,
IBlockEntityDelayedTickable {
    private static final int UPDATE_BACKOFF_TICKS = 1;
    private INBTProvider nbtProviderComponent = new NBTProviderComponent(this);
    private boolean shouldSendUpdate = false;
    private int sendUpdateBackoff = (int)Math.round(Math.random() * (double)this.getUpdateBackoffTicks());

    public CyclopsBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    @Override
    public int getUpdateBackoffTicks() {
        return 1;
    }

    @Override
    public void sendUpdate() {
        this.shouldSendUpdate = true;
    }

    @Override
    public boolean shouldSendUpdate() {
        return this.shouldSendUpdate;
    }

    @Override
    public void unsetSendUpdate() {
        this.shouldSendUpdate = false;
    }

    @Override
    public void setUpdateBackoff(int updateBackoff) {
        this.sendUpdateBackoff = updateBackoff;
    }

    @Override
    public int getUpdateBackoff() {
        return this.sendUpdateBackoff;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean canInteractWith(Player entityPlayer) {
        return true;
    }

    public void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        this.writeGeneratedFieldsToNBT(output);
    }

    public void writeToItemStack(ValueOutput output) {
        this.saveAdditional(output);
    }

    public final void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        this.read(input);
    }

    public void read(ValueInput input) {
        this.readGeneratedFieldsFromNBT(input);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    protected Direction transformFacingForRotation(Direction facing) {
        if (facing == null) {
            return null;
        }
        if (this.getRotation() == null) {
            return facing;
        }
        return DirectionHelpers.transformFacingForRotation(facing, this.getRotation());
    }

    public Direction getRotation() {
        return null;
    }

    @Override
    public void onDirty() {
        this.setChanged();
    }

    @Override
    public void writeGeneratedFieldsToNBT(ValueOutput output) {
        this.nbtProviderComponent.writeGeneratedFieldsToNBT(output);
    }

    @Override
    public void readGeneratedFieldsFromNBT(ValueInput input) {
        this.nbtProviderComponent.readGeneratedFieldsFromNBT(input);
    }
}

