/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.gametest;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.gametest.framework.TestData;
import net.minecraft.gametest.framework.TestEnvironmentDefinition;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.cyclopscore.gametest.GameTest;
import org.cyclops.cyclopscore.gametest.MethodGameTestInstance;

public class GameTestLoaderHelpers {
    public static boolean areGameTestsEnabled(String modId) {
        return System.getProperty("neoforge.enabledGameTestNamespaces", "").contains(modId) || System.getProperty("cyclopsmc.enabledGameTestNamespaces", "").contains(modId);
    }

    public static void registerCommonTests(String modId, Class<?>[] testClasses, BiConsumer<ResourceLocation, GameTestInstance> registrar, Registry<TestEnvironmentDefinition> testEnvironmentRegistry) {
        for (MethodGameTestInstance testInstance : GameTestLoaderHelpers.generateCommonTests(modId, testClasses, testEnvironmentRegistry)) {
            registrar.accept(testInstance.getId(), testInstance);
        }
    }

    public static Collection<MethodGameTestInstance> generateCommonTests(String modId, Class<?>[] testClasses, Registry<TestEnvironmentDefinition> testEnvironmentRegistry) {
        ArrayList testsList = Lists.newArrayList();
        for (Class<?> clazz : testClasses) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(GameTest.class)) continue;
                GameTest gameTest = method.getAnnotation(GameTest.class);
                Holder.Reference environment = testEnvironmentRegistry.getOrThrow(ResourceKey.create((ResourceKey)Registries.TEST_ENVIRONMENT, (ResourceLocation)ResourceLocation.parse((String)gameTest.environment())));
                testsList.add(new MethodGameTestInstance((TestData<Holder<TestEnvironmentDefinition>>)new TestData((Object)environment, ResourceLocation.parse((String)gameTest.template()), gameTest.timeoutTicks(), gameTest.setupTicks(), gameTest.required(), gameTest.rotation(), gameTest.manualOnly(), gameTest.attempts(), gameTest.requiredSuccesses(), gameTest.skyAccess()), modId, clazz.getName(), method.getName()));
            }
        }
        return testsList;
    }
}

