/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.AdvancedButtonEnum;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.RecipeAppendix;
import org.cyclops.cyclopscore.infobook.pageelement.SectionAppendixClient;

public abstract class RecipeAppendixClient<S extends RecipeAppendix<?>>
extends SectionAppendixClient<S> {
    protected static final int TICK_DELAY = 30;

    protected RecipeAppendixClient(S sectionAppendix) {
        super(sectionAppendix);
    }

    protected int getTick(ScreenInfoBook gui) {
        return gui.getTick() / 30;
    }

    protected ItemStack prepareItemStacks(HolderSet<Item> items, int tick) {
        return this.prepareItemStacks(items.stream().map(ItemStack::new).toList(), tick);
    }

    protected ItemStack prepareItemStacks(List<ItemStack> itemStacks, int tick) {
        if (itemStacks.size() == 0) {
            return ItemStack.EMPTY;
        }
        return this.prepareItemStack(itemStacks.get(tick % itemStacks.size()).copy(), tick);
    }

    protected ItemStack prepareItemStack(ItemStack itemStack, int tick) {
        return itemStack;
    }

    protected void renderItem(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my, AdvancedButtonEnum buttonEnum) {
        this.renderItem(gui, guiGraphics, x, y, itemStack, mx, my, buttonEnum, 1.0f);
    }

    protected void renderItem(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, AdvancedButtonEnum buttonEnum) {
        this.renderItem(gui, guiGraphics, x, y, itemStack, mx, my, renderOverlays, buttonEnum, 1.0f);
    }

    protected void renderItem(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my, AdvancedButtonEnum buttonEnum, float chance) {
        this.renderItem(gui, guiGraphics, x, y, itemStack, mx, my, true, buttonEnum, chance);
    }

    protected void renderItem(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, AdvancedButtonEnum buttonEnum, float chance) {
        RecipeAppendixClient.renderItemForButton(gui, guiGraphics, x, y, itemStack, mx, my, renderOverlays, buttonEnum != null ? (ItemButton)((RecipeAppendix)this.getSectionAppendix()).getRenderItemHolders().get(buttonEnum) : null, chance);
    }

    public static void renderItemForButton(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, ItemButton button) {
        RecipeAppendixClient.renderItemForButton(gui, guiGraphics, x, y, itemStack, mx, my, renderOverlays, button, 1.0f);
    }

    public static void renderItemForButton(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my, boolean renderOverlays, ItemButton button, float chance) {
        if (renderOverlays) {
            gui.drawOuterBorder(guiGraphics, x, y, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        if (!itemStack.isEmpty()) {
            guiGraphics.pose().pushMatrix();
            guiGraphics.renderItem(itemStack, x, y);
            if (renderOverlays) {
                guiGraphics.renderItemDecorations(Minecraft.getInstance().font, itemStack, x, y);
            }
            guiGraphics.pose().popMatrix();
            if (chance != 1.0f) {
                String chanceString = chance * 100.0f + "%";
                gui.drawScaledCenteredString(guiGraphics, chanceString, x - 4, y + 3, gui.getFont().width(chanceString), 1.0f, 18, IModHelpers.get().getBaseHelpers().RGBAToInt(255, 255, 255, 255), true);
            }
            if (button != null && renderOverlays) {
                button.update(x, y, itemStack, gui);
            }
        }
    }

    protected void renderFluid(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, FluidStack fluidStack, int mx, int my, AdvancedButtonEnum buttonEnum) {
        this.renderFluid(gui, guiGraphics, x, y, fluidStack, mx, my, true, buttonEnum);
    }

    protected void renderFluid(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, FluidStack fluidStack, int mx, int my, boolean renderOverlays, AdvancedButtonEnum buttonEnum) {
        RecipeAppendixClient.renderFluidForButton(gui, guiGraphics, x, y, fluidStack, mx, my, renderOverlays, buttonEnum != null ? (FluidButton)((RecipeAppendix)this.getSectionAppendix()).getRenderItemHolders().get(buttonEnum) : null);
    }

    public static void renderFluidForButton(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, FluidStack fluidStack, int mx, int my, boolean renderOverlays, FluidButton button) {
        if (renderOverlays) {
            gui.drawOuterBorder(guiGraphics, x, y, 16, 16, 1.0f, 1.0f, 1.0f, 0.2f);
        }
        if (!fluidStack.isEmpty()) {
            IModHelpersNeoForge.get().getGuiHelpers().renderFluidSlot(guiGraphics, fluidStack, x, y);
            if (button != null && renderOverlays) {
                button.update(x, y, fluidStack, gui);
            }
        }
    }

    public static void renderItemTooltip(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, ItemStack itemStack, int mx, int my) {
        guiGraphics.pose().pushMatrix();
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16 && !itemStack.isEmpty()) {
            gui.renderTooltip(guiGraphics, itemStack, mx, my);
        }
        guiGraphics.pose().popMatrix();
    }

    public static void renderFluidTooltip(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, FluidStack fluidStack, int mx, int my) {
        if (mx >= x && my >= y && mx <= x + 16 && my <= y + 16 && !fluidStack.isEmpty()) {
            ArrayList lines = Lists.newArrayList();
            lines.add(fluidStack.getHoverName().copy().withColor(TextColor.fromLegacyFormat((ChatFormatting)fluidStack.getFluid().getFluidType().getRarity(fluidStack).color()).getValue()).getVisualOrderText());
            lines.add(FormattedCharSequence.forward((String)(fluidStack.getAmount() + " mB"), (Style)Style.EMPTY.withColor(TextColor.fromLegacyFormat((ChatFormatting)ChatFormatting.GRAY))));
            guiGraphics.setTooltipForNextFrame(gui.getFont(), (List)lines, mx, my);
        }
    }

    @Override
    public final void drawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        int yOffset = ((RecipeAppendix)this.getSectionAppendix()).getAdditionalHeight();
        gui.drawOuterBorder(guiGraphics, x - 1, y - 1 - yOffset, ((RecipeAppendix)this.getSectionAppendix()).getWidth() + 2, ((RecipeAppendix)this.getSectionAppendix()).getHeight() + 2, 0.5f, 0.5f, 0.5f, 0.4f);
        gui.drawTextBanner(guiGraphics, x + width / 2, y - 2 - yOffset);
        gui.drawScaledCenteredString(guiGraphics, IModHelpers.get().getL10NHelpers().localize(((RecipeAppendix)this.getSectionAppendix()).getUnlocalizedTitle(), new Object[0]), x, y - 2 - yOffset, width, 0.9f, gui.getBannerWidth() - 6, gui.getTitleColor());
        this.drawElementInner(gui, guiGraphics, x, y, width, height, page, mx, my);
    }

    protected abstract void drawElementInner(ScreenInfoBook var1, GuiGraphics var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    @Override
    protected void postDrawElement(ScreenInfoBook gui, GuiGraphics guiGraphics, int x, int y, int width, int height, int page, int mx, int my) {
        this.renderToolTips(guiGraphics, gui.getFont(), mx, my);
    }

    protected void renderToolTips(GuiGraphics guiGraphics, Font font, int mx, int my) {
        for (AdvancedButton renderItemHolder : ((RecipeAppendix)this.getSectionAppendix()).getRenderItemHolders().values()) {
            renderItemHolder.renderTooltip(guiGraphics, font, mx, my);
        }
    }

    public static class ItemButton
    extends ElementButton<ItemStack> {
        public ItemButton(IInfoBook infoBook) {
            super(infoBook);
        }

        @Override
        public void update(int x, int y, ItemStack element, ScreenInfoBook gui) {
            super.update(x, y, element.isEmpty() ? null : element, gui);
        }

        @Override
        public void renderTooltip(GuiGraphics guiGraphics, Font font, int mx, int my) {
            if (this.getElement() != null) {
                RecipeAppendixClient.renderItemTooltip(this.gui, guiGraphics, this.getX(), this.getY(), (ItemStack)this.getElement(), mx, my);
            }
        }

        @Override
        protected String getTranslationKey(ItemStack element) {
            return element.getItem().getDescriptionId();
        }
    }

    public static class FluidButton
    extends ElementButton<FluidStack> {
        public FluidButton(IInfoBook infoBook) {
            super(infoBook);
        }

        @Override
        protected String getTranslationKey(FluidStack element) {
            return element.getFluidType().getDescriptionId(element);
        }

        @Override
        public void renderTooltip(GuiGraphics guiGraphics, Font font, int mx, int my) {
            if (this.getElement() != null) {
                RecipeAppendixClient.renderFluidTooltip(this.gui, guiGraphics, this.getX(), this.getY(), (FluidStack)this.getElement(), mx, my);
            }
        }
    }

    public static abstract class ElementButton<E>
    extends AdvancedButton {
        private final IInfoBook infoBook;
        private E element;

        public ElementButton(IInfoBook infoBook) {
            this.infoBook = infoBook;
        }

        public E getElement() {
            return this.element;
        }

        public void update(int x, int y, E element, ScreenInfoBook gui) {
            this.element = element;
            InfoSection target = null;
            if (this.element != null) {
                String translationKey = this.getTranslationKey(element);
                Pair<InfoSection, Integer> pair = this.infoBook.getConfigLinks().get(translationKey);
                if (pair != null) {
                    target = (InfoSection)pair.getLeft();
                }
            }
            super.update(x, y, (Component)Component.literal((String)"empty"), target, gui);
        }

        protected abstract String getTranslationKey(E var1);

        @Override
        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
            if (this.isVisible() && this.isHover(mouseX, mouseY)) {
                this.gui.drawOuterBorder(guiGraphics, this.getX(), this.getY(), 16, 16, 0.392f, 0.392f, 0.6f, 0.9f);
            }
        }

        @Override
        public boolean isVisible() {
            return super.isVisible() && this.element != null;
        }
    }
}

