/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.gametest.GameTestHolder;
import net.neoforged.neoforge.gametest.PrefixGameTestTemplate;
import net.neoforged.neoforge.items.IItemHandler;

@GameTestHolder(value="commoncapabilities")
@PrefixGameTestTemplate(value=false)
public class GameTestsVanillaCapabilitiesEntityItemFrame {
    public static final String TEMPLATE_EMPTY = "empty10";
    public static final BlockPos POS = BlockPos.ZERO.offset(2, 1, 2);

    @GameTest(template="empty10")
    public void testEntityItemFrameAdd(GameTestHelper helper) {
        ItemFrame entity = (ItemFrame)helper.spawn(EntityType.ITEM_FRAME, POS);
        entity.setItem(new ItemStack((ItemLike)Items.SHULKER_BOX));
        IItemHandler itemHandler = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY);
        ItemStack remaining = itemHandler.insertItem(0, new ItemStack((ItemLike)Items.APPLE), false);
        helper.succeedIf(() -> {
            helper.assertTrue(remaining.isEmpty(), "Remaining of insertion is not empty");
            helper.assertTrue(itemHandler.getStackInSlot(0).getItem() == Items.APPLE, "Item was not added");
        });
    }

    @GameTest(template="empty10")
    public void testEntityItemFrameRemove(GameTestHelper helper) {
        ItemFrame entity = (ItemFrame)helper.spawn(EntityType.ITEM_FRAME, POS);
        entity.setItem(new ItemStack((ItemLike)Items.SHULKER_BOX));
        IItemHandler itemHandler = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY);
        itemHandler.insertItem(0, new ItemStack((ItemLike)Items.APPLE), false);
        ItemStack removed = itemHandler.extractItem(0, 1, false);
        helper.succeedIf(() -> {
            helper.assertTrue(!removed.isEmpty(), "Removed item is empty");
            helper.assertTrue(itemHandler.getStackInSlot(0).isEmpty(), "Item was not removed");
        });
    }
}

