/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import java.util.PrimitiveIterator;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.inventory.IndexedSlotlessItemHandlerWrapper;
import org.cyclops.cyclopscore.inventory.LargeInventory;

@Deprecated
public class IndexedInventory
extends LargeInventory
implements IndexedSlotlessItemHandlerWrapper.IInventoryIndexReference {
    private final Map<Item, Int2ObjectMap<ItemStack>> index = Maps.newIdentityHashMap();
    private IntSet emptySlots = new IntAVLTreeSet();
    private IntSet nonEmptySlots = new IntAVLTreeSet();

    public IndexedInventory() {
        this(0, 0);
    }

    public IndexedInventory(int size, int stackLimit) {
        super(size, stackLimit);
        this.createIndex();
    }

    protected void createIndex() {
        this.index.clear();
        this.nonEmptySlots.clear();
        this.emptySlots.clear();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack itemStack = this.getItem(i);
            if (!itemStack.isEmpty()) {
                Int2ObjectOpenHashMap stacks = this.index.get(itemStack.getItem());
                if (stacks == null) {
                    stacks = new Int2ObjectOpenHashMap();
                    this.index.put(itemStack.getItem(), (Int2ObjectMap<ItemStack>)stacks);
                }
                stacks.put(i, (Object)itemStack);
                this.nonEmptySlots.add(i);
                continue;
            }
            this.emptySlots.add(i);
        }
    }

    @Override
    public void readFromNBT(HolderLookup.Provider provider, CompoundTag data, String tag) {
        super.readFromNBT(provider, data, tag);
        this.createIndex();
    }

    @Override
    public void setItem(int slotId, ItemStack itemStack) {
        Int2ObjectMap<ItemStack> stacks;
        ItemStack oldStack = this.getItem(slotId);
        boolean wasEmpty = oldStack.isEmpty();
        boolean isEmpty = itemStack.isEmpty();
        if (!oldStack.isEmpty()) {
            stacks = this.index.get(oldStack.getItem());
            if (stacks != null) {
                stacks.remove(slotId);
            }
            if (stacks.isEmpty()) {
                this.index.remove(oldStack.getItem());
            }
        }
        if (!itemStack.isEmpty()) {
            stacks = this.index.get(itemStack.getItem());
            if (stacks == null) {
                stacks = new Int2ObjectOpenHashMap();
                this.index.put(itemStack.getItem(), stacks);
            }
            stacks.put(slotId, (Object)itemStack);
        }
        super.setItem(slotId, itemStack);
        if (wasEmpty && !isEmpty) {
            this.emptySlots.remove(slotId);
            this.nonEmptySlots.add(slotId);
        }
        if (!wasEmpty && isEmpty) {
            this.emptySlots.add(slotId);
            this.nonEmptySlots.remove(slotId);
        }
        if (this.nonEmptySlots.size() + this.emptySlots.size() != this.getContainerSize()) {
            throw new IllegalStateException(String.format("Indexed inventory at inconsistent state %s %s %s (slot: %s).", this.nonEmptySlots, this.emptySlots, this.getContainerSize(), slotId));
        }
    }

    @Override
    public void clearContent() {
        super.clearContent();
        this.index.clear();
    }

    @Override
    public int getInventoryReferenceStackLimit() {
        return this.getMaxStackSize();
    }

    @Override
    public Map<Item, Int2ObjectMap<ItemStack>> getIndex() {
        return this.index;
    }

    @Override
    public PrimitiveIterator.OfInt getEmptySlots() {
        return new IndexedSlotlessItemHandlerWrapper.WrappedIntIterator(this.emptySlots.iterator());
    }

    @Override
    public PrimitiveIterator.OfInt getNonEmptySlots() {
        return new IndexedSlotlessItemHandlerWrapper.WrappedIntIterator(this.nonEmptySlots.iterator());
    }
}

