/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.item;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;
import org.cyclops.cyclopscore.inventory.InventoryLocationPlayer;
import org.cyclops.cyclopscore.inventory.ItemLocation;

public abstract class ItemGui
extends Item {
    protected ItemGui(Item.Properties properties) {
        super(properties);
    }

    @Nullable
    public abstract MenuProvider getContainer(Level var1, Player var2, ItemLocation var3);

    public abstract Class<? extends AbstractContainerMenu> getContainerClass(Level var1, Player var2, ItemStack var3);

    public boolean onDroppedByPlayer(ItemStack itemstack, Player player) {
        if (!itemstack.m_41619_() && player instanceof ServerPlayer && player.f_36096_ != null && player.f_36096_.getClass() == this.getContainerClass(player.f_19853_, player, itemstack)) {
            player.m_6915_();
        }
        return super.onDroppedByPlayer(itemstack, player);
    }

    public void openGuiForItemIndex(Level world, ServerPlayer player, ItemLocation itemLocation) {
        MenuProvider containerProvider;
        if (!world.m_5776_() && (containerProvider = this.getContainer(world, (Player)player, itemLocation)) != null) {
            NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)containerProvider, packetBuffer -> this.writeExtraGuiData((FriendlyByteBuf)packetBuffer, world, player, itemLocation));
            Stat<ResourceLocation> openStat = this.getOpenStat();
            if (openStat != null) {
                player.m_36246_(openStat);
            }
        }
    }

    public void writeExtraGuiData(FriendlyByteBuf packetBuffer, Level world, ServerPlayer player, ItemLocation itemLocation) {
        ItemLocation.writeToPacketBuffer(packetBuffer, itemLocation);
    }

    @Nullable
    protected Stat<ResourceLocation> getOpenStat() {
        return null;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player instanceof FakePlayer) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)itemStack);
        }
        if (player instanceof ServerPlayer) {
            this.openGuiForItemIndex(world, (ServerPlayer)player, InventoryLocationPlayer.getInstance().handToLocation(player, hand, player.m_150109_().f_35977_));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemStack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState blockState = level.m_8055_(pos);
        if (context.m_43722_().m_204117_(ItemTags.f_13162_) && blockState.m_60713_(Blocks.f_50624_)) {
            return LecternBlock.m_153566_((Player)context.m_43723_(), (Level)level, (BlockPos)pos, (BlockState)blockState, (ItemStack)context.m_43722_()) ? InteractionResult.m_19078_((boolean)level.f_46443_) : InteractionResult.PASS;
        }
        return super.m_6225_(context);
    }
}

