/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IProxyVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderConfig;
import org.cyclops.integrateddynamics.capability.networkelementprovider.NetworkElementProviderSingleton;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityActiveVariableBase;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityCableConnectableInventory;
import org.cyclops.integrateddynamics.core.evaluate.InventoryVariableEvaluator;
import org.cyclops.integrateddynamics.core.evaluate.ProxyVariableFacadeHandler;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.ProxyVariableFacade;
import org.cyclops.integrateddynamics.inventory.container.ContainerProxy;
import org.cyclops.integrateddynamics.network.ProxyNetworkElement;

public class BlockEntityProxy
extends BlockEntityActiveVariableBase<ProxyNetworkElement>
implements MenuProvider {
    public static final int INVENTORY_SIZE = 3;
    public static final int SLOT_READ = 0;
    public static final int SLOT_WRITE_IN = 1;
    public static final int SLOT_WRITE_OUT = 2;
    public static final String GLOBALCOUNTER_KEY = "proxy";
    @NBTPersist
    private int proxyId = -1;
    private Player lastPlayer = null;
    private boolean writeVariable;

    public BlockEntityProxy(BlockPos blockPos, BlockState blockState) {
        this(RegistryEntries.BLOCK_ENTITY_PROXY, blockPos, blockState, 3);
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.NORTH, LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.SOUTH, LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.EAST, LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.WEST, LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{0})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP, LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{1})));
        this.addCapabilitySided(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN, LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{2})));
    }

    public BlockEntityProxy(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState, int inventorySize) {
        super(type, blockPos, blockState, inventorySize);
        this.addCapabilityInternal(NetworkElementProviderConfig.CAPABILITY, LazyOptional.of(() -> new NetworkElementProviderSingleton(){

            @Override
            public INetworkElement createNetworkElement(Level world, BlockPos blockPos) {
                return new ProxyNetworkElement(DimPos.of((Level)world, (BlockPos)blockPos));
            }
        }));
    }

    public boolean isWriteVariable() {
        return this.writeVariable;
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new SimpleInventory(inventorySize, stackSize){

            public boolean m_7013_(int slot, ItemStack itemStack) {
                return slot != 2 && super.m_7013_(slot, itemStack);
            }
        };
    }

    @Override
    protected InventoryVariableEvaluator<IValue> createEvaluator() {
        return new InventoryVariableEvaluator<IValue>((Container)this.getInventory(), this.getSlotRead(), (IValueType)ValueTypes.CATEGORY_ANY){

            @Override
            protected void preValidate() {
                super.preValidate();
                if (this.getVariableFacade() instanceof IProxyVariableFacade && ((IProxyVariableFacade)this.getVariableFacade()).getProxyId() == BlockEntityProxy.this.getProxyId()) {
                    this.addError(Component.m_237110_((String)"variable.integrateddynamics.error.recursion", (Object[])new Object[]{this.getVariableFacade().getId()}));
                }
            }
        };
    }

    public void generateNewProxyId() {
        this.proxyId = IntegratedDynamics.globalCounters.getNext(GLOBALCOUNTER_KEY);
        this.m_6596_();
    }

    @Override
    public int getSlotRead() {
        return 0;
    }

    protected int getSlotWriteIn() {
        return 1;
    }

    protected int getSlotWriteOut() {
        return 2;
    }

    @Override
    public void onDirty() {
        super.onDirty();
        if (!this.f_58857_.m_5776_()) {
            this.writeVariable = true;
        }
    }

    public ItemStack writeProxyInfo(boolean generateId, ItemStack itemStack, final int proxyId) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(generateId, itemStack, ProxyVariableFacadeHandler.getInstance(), new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IProxyVariableFacade>(){

            @Override
            public IProxyVariableFacade create(boolean generateId) {
                return new ProxyVariableFacade(generateId, proxyId);
            }

            @Override
            public IProxyVariableFacade create(int id) {
                return new ProxyVariableFacade(id, proxyId);
            }
        }, this.lastPlayer, this.m_58900_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerProxy(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.integrateddynamics.proxy");
    }

    public int getProxyId() {
        return this.proxyId;
    }

    public void setProxyId(int proxyId) {
        this.proxyId = proxyId;
    }

    public void setLastPlayer(Player lastPlayer) {
        this.lastPlayer = lastPlayer;
    }

    public static class Ticker<T extends BlockEntityProxy>
    extends BlockEntityCableConnectableInventory.Ticker<T> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, T blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (((BlockEntityProxy)blockEntity).isWriteVariable() && !((BlockEntityCableConnectableInventory)((Object)blockEntity)).getInventory().m_8020_(((BlockEntityProxy)blockEntity).getSlotWriteIn()).m_41619_() && ((BlockEntityCableConnectableInventory)((Object)blockEntity)).getInventory().m_8020_(((BlockEntityProxy)blockEntity).getSlotWriteOut()).m_41619_()) {
                ItemStack outputStack = ((BlockEntityProxy)blockEntity).writeProxyInfo(!blockEntity.m_58904_().f_46443_, ((BlockEntityCableConnectableInventory)((Object)blockEntity)).getInventory().m_8016_(((BlockEntityProxy)blockEntity).getSlotWriteIn()), ((BlockEntityProxy)blockEntity).getProxyId());
                ((BlockEntityCableConnectableInventory)((Object)blockEntity)).getInventory().m_6836_(((BlockEntityProxy)blockEntity).getSlotWriteOut(), outputStack);
            }
        }
    }
}

