/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.model;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemModelGenerator;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import net.minecraftforge.client.model.geometry.UnbakedGeometryHelper;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelProvider;
import org.cyclops.integrateddynamics.core.client.model.ModelHelpers;
import org.cyclops.integrateddynamics.core.client.model.VariableModelBaked;
import org.cyclops.integrateddynamics.core.client.model.VariableModelProviders;

public class VariableModel
implements UnbakedModel,
IUnbakedGeometry<VariableModel> {
    private final BlockModel base;

    public VariableModel(BlockModel base) {
        this.base = base;
    }

    public void loadSubModels(List<ResourceLocation> subModels) {
        for (IVariableModelProvider<? extends IVariableModelProvider.BakedModelProvider> provider : VariableModelProviders.REGISTRY.getProviders()) {
            provider.loadModels(subModels);
        }
    }

    public static void addAdditionalModels(ImmutableSet.Builder<ResourceLocation> builder) {
        for (IVariableModelProvider<? extends IVariableModelProvider.BakedModelProvider> provider : VariableModelProviders.REGISTRY.getProviders()) {
            builder.addAll(provider.getDependencies());
        }
    }

    public Collection<ResourceLocation> m_7970_() {
        if (this.base.getParentLocation() == null || this.base.getParentLocation().m_135815_().startsWith("builtin/")) {
            return Collections.emptyList();
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)this.base.getParentLocation());
        VariableModel.addAdditionalModels((ImmutableSet.Builder<ResourceLocation>)builder);
        return builder.build();
    }

    public Collection<Material> m_5500_(Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        this.base.f_111418_ = ModelHelpers.MODEL_GENERATED;
        HashSet textures = Sets.newHashSet((Object[])new Material[]{this.base.m_111480_("particle")});
        if (this.base.m_111490_() == ModelBakery.f_119232_) {
            ItemModelGenerator.f_111635_.forEach(p_228814_2_ -> textures.add(this.base.m_111480_(p_228814_2_)));
        }
        for (Either texture : this.base.f_111417_.values()) {
            texture.ifLeft(textures::add);
        }
        return textures;
    }

    @Nullable
    public BakedModel m_7611_(ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState transform, ResourceLocation location) {
        Material textureName = this.base.m_111480_("layer0");
        BlockModel itemModel = ModelHelpers.MODEL_GENERATOR.m_111670_(spriteGetter, this.base);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(itemModel, itemModel.getOverrides(bakery, itemModel, spriteGetter), false);
        itemModel.f_111417_.put("layer0", Either.left((Object)textureName));
        TextureAtlasSprite textureAtlasSprite = spriteGetter.apply(textureName);
        builder.m_119528_(textureAtlasSprite);
        for (BakedQuad bakedQuad : UnbakedGeometryHelper.bakeElements((List)UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)textureAtlasSprite), $ -> textureAtlasSprite, (ModelState)transform, (ResourceLocation)location)) {
            builder.m_119526_(bakedQuad);
        }
        BakedModel baseModel = builder.m_119533_();
        VariableModelBaked bakedModel = new VariableModelBaked(baseModel);
        for (IVariableModelProvider<? extends IVariableModelProvider.BakedModelProvider> provider : VariableModelProviders.REGISTRY.getProviders()) {
            bakedModel.setSubModels(provider, provider.bakeOverlayModels(bakery, spriteGetter, transform, location));
        }
        return bakedModel;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return this.m_7611_(bakery, spriteGetter, modelTransform, modelLocation);
    }

    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.m_5500_(modelGetter, missingTextureErrors);
    }
}

