/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeUniquelyNamed;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.helper.Helpers;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeItemStackLPElement;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;

public class ValueObjectTypeFluidStack
extends ValueObjectTypeBase<ValueFluidStack>
implements IValueTypeNamed<ValueFluidStack>,
IValueTypeUniquelyNamed<ValueFluidStack>,
IValueTypeNullable<ValueFluidStack> {
    public ValueObjectTypeFluidStack() {
        super("fluidstack", ValueFluidStack.class);
    }

    @Override
    public ValueFluidStack getDefault() {
        return ValueFluidStack.of(FluidStack.EMPTY);
    }

    @Override
    public MutableComponent toCompactString(ValueFluidStack value) {
        FluidStack fluidStack = value.getRawValue();
        return !fluidStack.isEmpty() ? ((MutableComponent)fluidStack.getDisplayName()).m_130946_(String.format(" (%s mB)", fluidStack.getAmount())) : Component.m_237113_((String)"");
    }

    @Override
    public Tag serialize(ValueFluidStack value) {
        CompoundTag tag = new CompoundTag();
        value.getRawValue().writeToNBT(tag);
        return tag;
    }

    @Override
    public ValueFluidStack deserialize(Tag value) {
        if (value instanceof CompoundTag) {
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)((CompoundTag)value));
            return ValueFluidStack.of(fluidStack);
        }
        return null;
    }

    @Override
    public String getName(ValueFluidStack a) {
        return this.toCompactString(a).getString();
    }

    @Override
    public boolean isNull(ValueFluidStack a) {
        return a.getRawValue().isEmpty();
    }

    @Override
    public ValueTypeLPElementBase createLogicProgrammerElement() {
        return new ValueTypeItemStackLPElement<ValueFluidStack>(this, new ValueTypeItemStackLPElement.IItemStackToValue<ValueFluidStack>(){

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public Component validate(ItemStack itemStack) {
                BlockItem blockItem;
                Item item;
                return itemStack.m_41619_() || FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent() || (item = itemStack.m_41720_()) instanceof BlockItem && (blockItem = (BlockItem)item) instanceof IFluidBlock ? null : Component.m_237115_((String)"valuetype.integrateddynamics.error.fluid.no_fluid");
            }

            @Override
            public ValueFluidStack getValue(ItemStack itemStack) {
                return ValueFluidStack.of(Helpers.getFluidStack(itemStack));
            }

            @Override
            public ItemStack getValueAsItemStack(ValueFluidStack value) {
                return value.getRawValue().getFluid().getFluidType().getBucket(value.getRawValue());
            }
        });
    }

    @Override
    public String getUniqueName(ValueFluidStack value) {
        FluidStack fluidStack = value.getRawValue();
        return !fluidStack.isEmpty() ? String.format("%s %s", ForgeRegistries.FLUIDS.getKey((Object)fluidStack.getFluid()), fluidStack.getAmount()) : "";
    }

    public static class ValueFluidStack
    extends ValueBase {
        private final FluidStack fluidStack;

        private ValueFluidStack(FluidStack itemStack) {
            super(ValueTypes.OBJECT_FLUIDSTACK);
            this.fluidStack = Objects.requireNonNull(itemStack, "Attempted to create a ValueFluidStack for a null FluidStack.");
        }

        public static ValueFluidStack of(FluidStack itemStack) {
            return new ValueFluidStack(itemStack);
        }

        public FluidStack getRawValue() {
            return this.fluidStack;
        }

        public boolean equals(Object o) {
            return o instanceof ValueFluidStack && this.getRawValue().isFluidStackIdentical(((ValueFluidStack)o).getRawValue());
        }

        public int hashCode() {
            return this.fluidStack.hashCode();
        }

        @Override
        public String toString() {
            return "ValueObjectTypeFluidStack.ValueFluidStack(fluidStack=" + String.valueOf(this.fluidStack) + ")";
        }
    }
}

