/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable.gui;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElementValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBoolean;
import org.cyclops.integrateddynamics.core.evaluate.variable.gui.GuiElementValueTypeBooleanRenderPattern;

public class GuiElementValueTypeBoolean<G extends GuiComponent, C extends AbstractContainerMenu>
implements IGuiInputElementValueType<GuiElementValueTypeBooleanRenderPattern, G, C> {
    private final ValueTypeBoolean valueType;
    private Predicate<IValue> validator;
    private final IConfigRenderPattern renderPattern;
    private final boolean defaultInputBoolean;
    private boolean inputBoolean;

    public GuiElementValueTypeBoolean(ValueTypeBoolean valueType, IConfigRenderPattern renderPattern) {
        this.valueType = valueType;
        this.validator = Predicates.alwaysTrue();
        this.renderPattern = renderPattern;
        this.defaultInputBoolean = valueType.getDefault().getRawValue();
    }

    public boolean getDefaultInputBoolean() {
        return this.inputBoolean;
    }

    public boolean getInputBoolean() {
        return this.inputBoolean;
    }

    @Override
    public void setValue(IValue value) {
        this.setInputBoolean(((ValueTypeBoolean.ValueBoolean)value).getRawValue());
    }

    @Override
    public void setValueInGui(GuiElementValueTypeBooleanRenderPattern subGui, boolean sendToServer) {
        if (subGui != null) {
            subGui.getCheckbox().setChecked(this.inputBoolean);
            if (sendToServer) {
                subGui.sendValueToServer();
            }
        }
    }

    public void setInputBoolean(boolean inputBoolean) {
        this.inputBoolean = inputBoolean;
    }

    @Override
    public void setValidator(Predicate<IValue> validator) {
        this.validator = validator;
    }

    @Override
    public IValue getValue() {
        return ValueTypeBoolean.ValueBoolean.of(this.getInputBoolean());
    }

    @Override
    public Component getName() {
        return Component.m_237115_((String)this.getValueType().getTranslationKey());
    }

    @Override
    public void loadTooltip(List<Component> lines) {
        this.getValueType().loadTooltip(lines, true, null);
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return this.renderPattern;
    }

    @Override
    public void activate() {
        this.inputBoolean = this.defaultInputBoolean;
    }

    @Override
    public void deactivate() {
    }

    @Override
    public Component validate() {
        if (!this.validator.test(ValueTypeBoolean.ValueBoolean.of(this.inputBoolean))) {
            return Component.m_237115_((String)"valuetype.integrateddynamics.error.value");
        }
        return null;
    }

    @Override
    public int getColor() {
        return this.getValueType().getDisplayColor();
    }

    @Override
    public String getSymbol() {
        return L10NHelpers.localize((String)this.getValueType().getTranslationKey(), (Object[])new Object[0]);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiElementValueTypeBooleanRenderPattern<?, G, C> createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, G gui, C container) {
        return new GuiElementValueTypeBooleanRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
    }

    public ValueTypeBoolean getValueType() {
        return this.valueType;
    }

    public Predicate<IValue> getValidator() {
        return this.validator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiElementValueTypeBoolean)) {
            return false;
        }
        GuiElementValueTypeBoolean other = (GuiElementValueTypeBoolean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDefaultInputBoolean() != other.getDefaultInputBoolean()) {
            return false;
        }
        if (this.getInputBoolean() != other.getInputBoolean()) {
            return false;
        }
        ValueTypeBoolean this$valueType = this.getValueType();
        ValueTypeBoolean other$valueType = other.getValueType();
        if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
            return false;
        }
        Predicate<IValue> this$validator = this.getValidator();
        Predicate<IValue> other$validator = other.getValidator();
        if (this$validator == null ? other$validator != null : !this$validator.equals(other$validator)) {
            return false;
        }
        IConfigRenderPattern this$renderPattern = this.getRenderPattern();
        IConfigRenderPattern other$renderPattern = other.getRenderPattern();
        return !(this$renderPattern == null ? other$renderPattern != null : !this$renderPattern.equals(other$renderPattern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiElementValueTypeBoolean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.getDefaultInputBoolean() ? 79 : 97);
        result = result * 59 + (this.getInputBoolean() ? 79 : 97);
        ValueTypeBoolean $valueType = this.getValueType();
        result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
        Predicate<IValue> $validator = this.getValidator();
        result = result * 59 + ($validator == null ? 43 : $validator.hashCode());
        IConfigRenderPattern $renderPattern = this.getRenderPattern();
        result = result * 59 + ($renderPattern == null ? 43 : $renderPattern.hashCode());
        return result;
    }

    public String toString() {
        return "GuiElementValueTypeBoolean(valueType=" + String.valueOf(this.getValueType()) + ", validator=" + String.valueOf(this.getValidator()) + ", renderPattern=" + String.valueOf(this.getRenderPattern()) + ", defaultInputBoolean=" + this.getDefaultInputBoolean() + ", inputBoolean=" + this.getInputBoolean() + ")";
    }
}

