/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.recipe.type;

import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.energy.CapabilityEnergy;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageMutable;

public class RecipeEnergyContainerCombination
extends CustomRecipe {
    private final Ingredient batteryItem;
    private final int maxCapacity;

    public RecipeEnergyContainerCombination(ResourceLocation id, Ingredient batteryItem, int maxCapacity) {
        super(id);
        this.batteryItem = batteryItem;
        this.maxCapacity = maxCapacity;
    }

    public Ingredient getBatteryItem() {
        return this.batteryItem;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public boolean matches(CraftingContainer grid, Level world) {
        return !this.assemble(grid).m_41619_();
    }

    public ItemStack m_8043_() {
        return this.batteryItem.m_43908_()[0];
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventory) {
        NonNullList aitemstack = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            aitemstack.set(i, (Object)ForgeHooks.getCraftingRemainingItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public RecipeSerializer<?> m_7707_() {
        return RegistryEntries.RECIPESERIALIZER_ENERGY_CONTAINER_COMBINATION;
    }

    public ItemStack assemble(CraftingContainer grid) {
        ItemStack output = this.m_8043_().m_41777_();
        IEnergyStorageCapacity energyStorage = (IEnergyStorageCapacity)output.getCapability(CapabilityEnergy.ENERGY).orElse(null);
        int totalCapacity = 0;
        int totalEnergy = 0;
        int inputItems = 0;
        for (int j = 0; j < grid.m_6643_(); ++j) {
            ItemStack element = grid.m_8020_(j).m_41777_().m_41620_(1);
            if (element.m_41619_()) continue;
            if (this.batteryItem.test(element)) {
                IEnergyStorageCapacity currentEnergyStorage = (IEnergyStorageCapacity)element.getCapability(CapabilityEnergy.ENERGY).orElse(null);
                ++inputItems;
                totalEnergy = Helpers.addSafe((int)totalEnergy, (int)currentEnergyStorage.getEnergyStored());
                totalCapacity = Helpers.addSafe((int)totalCapacity, (int)currentEnergyStorage.getMaxEnergyStored());
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (inputItems < 2 || totalCapacity > this.maxCapacity) {
            return ItemStack.f_41583_;
        }
        energyStorage.setCapacity(totalCapacity);
        ((IEnergyStorageMutable)((Object)energyStorage)).setEnergy(totalEnergy);
        return output;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 9;
    }
}

