/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.recipe;

import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.RegistryEntries;

public class ItemFacadeRecipe
extends CustomRecipe {
    private NonNullList<Ingredient> ingredients;

    public ItemFacadeRecipe(ResourceLocation id) {
        super(id);
    }

    public NonNullList<Ingredient> m_7527_() {
        if (this.ingredients == null) {
            try {
                this.ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.m_8043_()}), new BlocksIngredient()});
            }
            catch (RuntimeException e) {
                return NonNullList.m_122779_();
            }
        }
        return this.ingredients;
    }

    public boolean matches(CraftingContainer grid, Level world) {
        return !this.assemble(grid).m_41619_();
    }

    public ItemStack m_8043_() {
        return new ItemStack((ItemLike)RegistryEntries.ITEM_FACADE);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventory) {
        NonNullList aitemstack = NonNullList.m_122780_((int)inventory.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inventory.m_8020_(i);
            aitemstack.set(i, (Object)ForgeHooks.getCraftingRemainingItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    public ItemStack assemble(CraftingContainer grid) {
        ItemStack output = this.m_8043_().m_41777_();
        int facades = 0;
        ItemStack block = ItemStack.f_41583_;
        for (int j = 0; j < grid.m_6643_(); ++j) {
            ItemStack element = grid.m_8020_(j);
            if (element.m_41619_()) continue;
            if (element.m_41720_() == output.m_41720_()) {
                ++facades;
                continue;
            }
            if (block.m_41619_() && element.m_41720_() instanceof BlockItem && !((BlockItem)element.m_41720_()).m_40614_().m_7923_(((BlockItem)element.m_41720_()).m_40614_().m_49966_())) {
                block = element;
                continue;
            }
            return ItemStack.f_41583_;
        }
        if (facades != 1 || block.m_41619_()) {
            return ItemStack.f_41583_;
        }
        RegistryEntries.ITEM_FACADE.writeFacadeBlock(output, BlockHelpers.getBlockStateFromItemStack((ItemStack)block));
        return output;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return RegistryEntries.RECIPESERIALIZER_FACADE;
    }

    public static class BlocksIngredient
    extends Ingredient {
        protected BlocksIngredient() {
            super(ForgeRegistries.BLOCKS.getValues().stream().map(ItemStack::new).map(Ingredient.ItemValue::new));
        }

        public boolean test(@Nullable ItemStack itemStack) {
            return itemStack != null && !itemStack.m_41619_() && itemStack.m_41720_() instanceof BlockItem;
        }
    }
}

