/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.block;

import de.sarocesch.pakourblocks.ParkourBlocksMod;
import de.sarocesch.pakourblocks.block.ParkourBlockEntity;
import de.sarocesch.pakourblocks.block.ParkourBlockTicker;
import de.sarocesch.pakourblocks.client.gui.ParkourBlockScreen;
import de.sarocesch.pakourblocks.config.ModConfig;
import de.sarocesch.pakourblocks.item.TunerItem;
import de.sarocesch.pakourblocks.network.NetworkHandler;
import de.sarocesch.pakourblocks.network.PacketSetPaused;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParkourBlock
extends Block
implements EntityBlock {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParkourBlock.class);
    public static final BooleanProperty DISGUISED = BooleanProperty.m_61465_((String)"disguised");
    public static final BooleanProperty BLOCKED = BooleanProperty.m_61465_((String)"blocked");
    public static final EnumProperty<DisguiseType> DISGUISE_TYPE = EnumProperty.m_61587_((String)"disguise_type", DisguiseType.class);
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final ParkourBlockTicker TICKER = new ParkourBlockTicker();

    public ParkourBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)DISGUISED, (Comparable)Boolean.FALSE)).m_61124_((Property)BLOCKED, (Comparable)Boolean.FALSE)).m_61124_(DISGUISE_TYPE, (Comparable)((Object)DisguiseType.STONE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DISGUISED, BLOCKED, DISGUISE_TYPE});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)DISGUISED, (Comparable)Boolean.FALSE)).m_61124_((Property)BLOCKED, (Comparable)Boolean.FALSE);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape disguiseShape;
        ParkourBlockEntity parkourBlockEntity;
        BlockState disguiseState;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)DISGUISED)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof ParkourBlockEntity && (disguiseState = (parkourBlockEntity = (ParkourBlockEntity)blockEntity).getDisguiseState()) != null && !(disguiseShape = disguiseState.m_60651_(level, pos, context)).m_83281_()) {
            return disguiseShape;
        }
        return SHAPE;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        ParkourBlockEntity parkourBlockEntity;
        BlockState disguiseState;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)DISGUISED)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof ParkourBlockEntity && (disguiseState = (parkourBlockEntity = (ParkourBlockEntity)blockEntity).getDisguiseState()) != null) {
            return disguiseState.m_60791_();
        }
        return super.getLightEmission(state, level, pos);
    }

    public int m_7753_(BlockState state, BlockGetter level, BlockPos pos) {
        ParkourBlockEntity parkourBlockEntity;
        BlockState disguiseState;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)DISGUISED)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof ParkourBlockEntity && (disguiseState = (parkourBlockEntity = (ParkourBlockEntity)blockEntity).getDisguiseState()) != null) {
            return disguiseState.m_60739_(level, pos);
        }
        return super.m_7753_(state, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        ParkourBlockEntity parkourBlockEntity;
        BlockState disguiseState;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)DISGUISED)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof ParkourBlockEntity && (disguiseState = (parkourBlockEntity = (ParkourBlockEntity)blockEntity).getDisguiseState()) != null) {
            return disguiseState.m_60827_();
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public float getFriction(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        ParkourBlockEntity parkourBlockEntity;
        BlockState disguiseState;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)DISGUISED)).booleanValue() && (blockEntity = level.m_7702_(pos)) instanceof ParkourBlockEntity && (disguiseState = (parkourBlockEntity = (ParkourBlockEntity)blockEntity).getDisguiseState()) != null) {
            return disguiseState.m_60734_().m_49958_();
        }
        return super.getFriction(state, level, pos, entity);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.BLOCK;
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        ItemStack heldItem = player.m_21120_(hand);
        ItemStack offhandItem = player.m_21206_();
        Item item = heldItem.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (offhandItem.m_41720_() instanceof TunerItem) {
                BlockState disguiseState;
                blockEntity = level.m_7702_(pos);
                if (!(blockEntity instanceof ParkourBlockEntity)) return InteractionResult.PASS;
                ParkourBlockEntity parkourBlockEntity = (ParkourBlockEntity)blockEntity;
                Block block = blockItem.m_40614_();
                if (block instanceof ParkourBlock) {
                    return InteractionResult.PASS;
                }
                if (player.m_9236_().m_8055_(hit.m_82425_().m_121945_(hit.m_82434_().m_122424_())).m_60713_(block)) {
                    disguiseState = player.m_9236_().m_8055_(hit.m_82425_().m_121945_(hit.m_82434_().m_122424_()));
                    if (ModConfig.debugMode) {
                        LOGGER.info("Using actual block state from world: {}", (Object)disguiseState);
                    }
                } else {
                    CompoundTag blockStateTag = heldItem.m_41737_("BlockStateTag");
                    if (blockStateTag != null) {
                        disguiseState = block.m_49966_();
                        for (String key : blockStateTag.m_128431_()) {
                            for (Property property : disguiseState.m_61147_()) {
                                if (!property.m_61708_().equals(key)) continue;
                                String value = blockStateTag.m_128461_(key);
                                disguiseState = this.applyProperty(disguiseState, property, value);
                            }
                        }
                        if (ModConfig.debugMode) {
                            LOGGER.info("Using block state from item tag: {}", (Object)disguiseState);
                        }
                    } else {
                        disguiseState = block.m_49966_();
                        if (ModConfig.debugMode) {
                            LOGGER.info("Using default block state: {}", (Object)disguiseState);
                        }
                    }
                }
                if (!player.m_150110_().f_35937_ && parkourBlockEntity.getDisguiseState() != null) {
                    BlockState oldDisguiseState = parkourBlockEntity.getDisguiseState();
                    Block oldDisguiseBlock = oldDisguiseState.m_60734_();
                    ItemStack oldDisguiseItem = new ItemStack((ItemLike)oldDisguiseBlock);
                    ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, oldDisguiseItem);
                    level.m_7967_((Entity)itemEntity);
                    if (ModConfig.debugMode) {
                        LOGGER.info("Dropped old disguise block {} at {}", (Object)oldDisguiseBlock.m_49954_().getString(), (Object)pos);
                    }
                }
                parkourBlockEntity.setDisguiseState(disguiseState);
                ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)disguiseState.m_60734_());
                String blockIdString = blockId.toString();
                DisguiseType disguiseType = DisguiseType.fromBlockId(blockIdString);
                BlockState newState = (BlockState)((BlockState)state.m_61124_((Property)DISGUISED, (Comparable)Boolean.TRUE)).m_61124_(DISGUISE_TYPE, (Comparable)((Object)disguiseType));
                level.m_7731_(pos, newState, 3);
                level.m_7260_(pos, state, newState, 3);
                level.m_46745_(pos).m_8092_(true);
                if (ModConfig.debugMode) {
                    LOGGER.info("Disguised ParkourBlock at {} as {}", (Object)pos, (Object)block.m_49954_().getString());
                }
                level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player.m_150110_().f_35937_) return InteractionResult.m_19078_((boolean)level.f_46443_);
                heldItem.m_41774_(1);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        if (!(heldItem.m_41720_() instanceof TunerItem)) return InteractionResult.PASS;
        blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ParkourBlockEntity) {
            ParkourBlockEntity parkourBlockEntity = (ParkourBlockEntity)blockEntity;
            if (parkourBlockEntity.isBlocked()) {
                parkourBlockEntity.setBlocked(false);
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)BLOCKED, (Comparable)Boolean.FALSE), 3);
                if (ModConfig.debugMode) {
                    LOGGER.info("Unblocked ParkourBlock at {}", (Object)pos);
                }
            }
            if (parkourBlockEntity.isMovementEnabled() && !parkourBlockEntity.isPaused()) {
                if (level.f_46443_) {
                    NetworkHandler.CHANNEL.sendToServer((Object)new PacketSetPaused(pos, true));
                } else {
                    parkourBlockEntity.setPaused(true);
                }
                if (ModConfig.debugMode) {
                    LOGGER.info("Paused moving ParkourBlock at {}", (Object)pos);
                }
            }
        }
        if (!level.f_46443_) return InteractionResult.m_19078_((boolean)level.f_46443_);
        this.openSettingsScreen(pos);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openSettingsScreen(BlockPos pos) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.m_91087_().m_91152_((Screen)new ParkourBlockScreen(pos)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (ModConfig.debugMode) {
            LOGGER.info("Creating new ParkourBlockEntity at {}", (Object)pos);
        }
        ParkourBlockEntity entity = new ParkourBlockEntity(pos, state);
        if (((Boolean)state.m_61143_((Property)DISGUISED)).booleanValue() && ModConfig.debugMode) {
            LOGGER.info("New block is disguised, but disguise state is not set yet");
        }
        return entity;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (blockEntityType == ParkourBlocksMod.PARKOUR_BLOCK_ENTITY.get()) {
            return (level1, pos, state1, blockEntity) -> {
                if (blockEntity instanceof ParkourBlockEntity) {
                    boolean shouldBeDisguised;
                    ParkourBlockEntity parkourBlockEntity = (ParkourBlockEntity)blockEntity;
                    boolean isBlocked = parkourBlockEntity.isBlocked();
                    boolean stateBlocked = (Boolean)state1.m_61143_((Property)BLOCKED);
                    boolean stateDisguised = (Boolean)state1.m_61143_((Property)DISGUISED);
                    BlockState disguiseState = parkourBlockEntity.getDisguiseState();
                    boolean bl = shouldBeDisguised = disguiseState != null;
                    if (isBlocked != stateBlocked || shouldBeDisguised != stateDisguised) {
                        BlockState newState = state1;
                        if (isBlocked != stateBlocked) {
                            newState = (BlockState)newState.m_61124_((Property)BLOCKED, (Comparable)Boolean.valueOf(isBlocked));
                        }
                        if (shouldBeDisguised != stateDisguised) {
                            newState = (BlockState)newState.m_61124_((Property)DISGUISED, (Comparable)Boolean.valueOf(shouldBeDisguised));
                        }
                        level1.m_7731_(pos, newState, 3);
                        level1.m_7260_(pos, state1, newState, 3);
                        if (ModConfig.debugMode) {
                            LOGGER.info("Updated block state at {}: BLOCKED={}, DISGUISED={}", new Object[]{pos, isBlocked, shouldBeDisguised});
                        }
                    }
                }
                TICKER.tick(level1, pos, state1, (ParkourBlockEntity)blockEntity);
            };
        }
        return null;
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!level.f_46443_ && entity instanceof Player) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ParkourBlockEntity) {
                ParkourBlockEntity parkourBlockEntity = (ParkourBlockEntity)blockEntity;
                if (ModConfig.debugMode) {
                    LOGGER.info("Player stepped on ParkourBlock at {}. Applying {} effects.", (Object)pos, (Object)parkourBlockEntity.getEffects().size());
                }
                parkourBlockEntity.applyEffectsToPlayer((Player)entity);
            } else if (ModConfig.debugMode) {
                LOGGER.warn("No ParkourBlockEntity found at {} when player stepped on it!", (Object)pos);
            }
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag disguiseTag;
        String blockId;
        ResourceLocation blockResLoc;
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag != null && tag.m_128441_("DisguiseState") && (blockResLoc = ResourceLocation.m_135820_((String)(blockId = (disguiseTag = tag.m_128469_("DisguiseState")).m_128461_("Name")))) != null) {
            Block block = (Block)BuiltInRegistries.f_256975_.m_7745_(blockResLoc);
            Object variant = "";
            if (disguiseTag.m_128441_("Properties")) {
                CompoundTag propertiesTag = disguiseTag.m_128469_("Properties");
                for (String key : propertiesTag.m_128431_()) {
                    variant = (String)variant + key + "=" + propertiesTag.m_128461_(key) + ", ";
                }
                if (!((String)variant).isEmpty()) {
                    variant = ((String)variant).substring(0, ((String)variant).length() - 2);
                }
            }
            if (!((String)variant).isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)("Disguised as: " + block.m_49954_().getString() + " (" + (String)variant + ")")));
            } else {
                tooltip.add((Component)Component.m_237113_((String)("Disguised as: " + block.m_49954_().getString())));
            }
        }
    }

    private <T extends Comparable<T>> BlockState applyProperty(BlockState state, Property<T> property, String valueString) {
        Optional value = property.m_6215_(valueString);
        if (value.isPresent()) {
            return (BlockState)state.m_61124_(property, (Comparable)value.get());
        }
        return state;
    }

    public static enum DisguiseType implements StringRepresentable
    {
        STONE("minecraft:stone"),
        COBBLESTONE("minecraft:cobblestone"),
        DIRT("minecraft:dirt"),
        GRASS_BLOCK("minecraft:grass_block"),
        OAK_PLANKS("minecraft:oak_planks"),
        SPRUCE_PLANKS("minecraft:spruce_planks"),
        BIRCH_PLANKS("minecraft:birch_planks"),
        JUNGLE_PLANKS("minecraft:jungle_planks"),
        ACACIA_PLANKS("minecraft:acacia_planks"),
        DARK_OAK_PLANKS("minecraft:dark_oak_planks"),
        SAND("minecraft:sand"),
        GRAVEL("minecraft:gravel"),
        GOLD_BLOCK("minecraft:gold_block"),
        IRON_BLOCK("minecraft:iron_block"),
        BRICKS("minecraft:bricks"),
        BOOKSHELF("minecraft:bookshelf"),
        MOSSY_COBBLESTONE("minecraft:mossy_cobblestone"),
        OBSIDIAN("minecraft:obsidian"),
        DIAMOND_BLOCK("minecraft:diamond_block"),
        CRAFTING_TABLE("minecraft:crafting_table"),
        FURNACE("minecraft:furnace"),
        REDSTONE_BLOCK("minecraft:redstone_block"),
        SNOW_BLOCK("minecraft:snow_block"),
        CLAY("minecraft:clay"),
        PUMPKIN("minecraft:pumpkin"),
        NETHERRACK("minecraft:netherrack"),
        SOUL_SAND("minecraft:soul_sand"),
        GLOWSTONE("minecraft:glowstone"),
        LIT_PUMPKIN("minecraft:lit_pumpkin"),
        STONE_BRICKS("minecraft:stone_bricks"),
        GLASS("minecraft:glass"),
        MELON("minecraft:melon"),
        END_STONE("minecraft:end_stone"),
        EMERALD_BLOCK("minecraft:emerald_block"),
        QUARTZ_BLOCK("minecraft:quartz_block"),
        TERRACOTTA("minecraft:terracotta"),
        HAY_BLOCK("minecraft:hay_block"),
        COAL_BLOCK("minecraft:coal_block"),
        PACKED_ICE("minecraft:packed_ice"),
        RED_SANDSTONE("minecraft:red_sandstone"),
        PURPUR_BLOCK("minecraft:purpur_block"),
        MAGMA_BLOCK("minecraft:magma_block"),
        NETHER_WART_BLOCK("minecraft:nether_wart_block"),
        BONE_BLOCK("minecraft:bone_block"),
        CONCRETE("minecraft:concrete"),
        CONCRETE_POWDER("minecraft:concrete_powder"),
        CORAL_BLOCK("minecraft:coral_block"),
        DRIED_KELP_BLOCK("minecraft:dried_kelp_block"),
        SMOOTH_STONE("minecraft:smooth_stone");

        private final String blockId;

        private DisguiseType(String blockId) {
            this.blockId = blockId;
        }

        public String getBlockId() {
            return this.blockId;
        }

        public static DisguiseType fromBlockId(String blockId) {
            if (ModConfig.debugMode) {
                LOGGER.info("Finding disguise type for block ID: {}", (Object)blockId);
            }
            for (DisguiseType type : DisguiseType.values()) {
                if (!type.blockId.equals(blockId)) continue;
                if (ModConfig.debugMode) {
                    LOGGER.info("Found exact match: {}", (Object)type.name());
                }
                return type;
            }
            DisguiseType result = null;
            result = blockId.contains("wool") ? STONE : (blockId.contains("leaves") ? GRASS_BLOCK : (blockId.contains("glass") ? GLASS : (blockId.contains("concrete") ? CONCRETE : (blockId.contains("terracotta") ? TERRACOTTA : (blockId.contains("planks") ? OAK_PLANKS : (blockId.contains("log") ? OAK_PLANKS : (blockId.contains("ore") ? STONE : (blockId.contains("sand") ? SAND : (blockId.contains("dirt") ? DIRT : STONE)))))))));
            if (ModConfig.debugMode) {
                LOGGER.info("No exact match found, using fallback: {} for {}", (Object)result.name(), (Object)blockId);
            }
            return result;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isBiomeDependent() {
            return this == GRASS_BLOCK || this.blockId.contains("grass") || this.blockId.contains("fern") || this.blockId.contains("leaves") || this.blockId.contains("coral");
        }
    }
}

