/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.block;

import de.sarocesch.pakourblocks.block.ParkourBlock;
import de.sarocesch.pakourblocks.block.ParkourBlockEntity;
import de.sarocesch.pakourblocks.config.ModConfig;
import de.sarocesch.pakourblocks.movement.MovementSequence;
import de.sarocesch.pakourblocks.movement.MovementStep;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParkourBlockTicker
implements BlockEntityTicker<ParkourBlockEntity> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParkourBlockTicker.class);
    private int currentStepIndex = 0;
    private int currentStepProgress = 0;
    private int tickCounter = 0;
    private BlockPos currentPos;
    private boolean isMoving = false;
    private boolean isReturning = false;
    private int startAttempts = 0;
    private BlockPos lastBlockPos = null;
    private BlockPos targetBlockPos = null;
    private Map<Entity, BlockPos> entitiesOnBlocks = new HashMap<Entity, BlockPos>();
    private MovementSequence savedSequence = null;
    private boolean savedMovementEnabled = false;
    private boolean savedDestroyBlocks = true;
    private List<MobEffectInstance> savedEffects = null;
    private BlockPos savedOriginalPos = null;
    private BlockState savedDisguiseState = null;

    public void tick(Level level, BlockPos pos, BlockState state, ParkourBlockEntity blockEntity) {
        LOGGER.info("ParkourBlockTicker.tick called for block at {}", (Object)pos);
        if (level.f_46443_) {
            return;
        }
        this.updateEntitiesOnBlocks(level);
        MovementSequence sequence = blockEntity.getMovementSequence();
        if (!blockEntity.isMovementEnabled() || sequence.getSteps().isEmpty() || blockEntity.isPaused()) {
            return;
        }
        this.currentPos = pos.m_7949_();
        if (blockEntity.getOriginalPos() == null) {
            blockEntity.setOriginalPos(pos);
            if (ModConfig.debugMode) {
                LOGGER.info("Set original position to {} for block", (Object)pos);
            }
        }
        ++this.tickCounter;
        if (!this.isMoving) {
            if (this.tickCounter % 20 == 0 || this.startAttempts < 3) {
                ++this.startAttempts;
                this.startNextStep(level, state, blockEntity, sequence);
            }
        } else {
            this.startAttempts = 0;
            this.continueCurrentStep(level, state, blockEntity, sequence);
        }
    }

    private void startNextStep(Level level, BlockState state, ParkourBlockEntity blockEntity, MovementSequence sequence) {
        if (this.isReturning) {
            BlockPos originalPos = blockEntity.getOriginalPos();
            if (this.currentPos.equals((Object)originalPos)) {
                this.isReturning = false;
                this.currentStepIndex = 0;
                if (ModConfig.debugMode) {
                    LOGGER.info("Returned to original position {}, starting sequence again", (Object)originalPos);
                }
            } else {
                this.isMoving = true;
                this.currentStepProgress = 0;
                if (ModConfig.debugMode) {
                    LOGGER.info("Returning to original position from {}", (Object)this.currentPos);
                }
                return;
            }
        }
        if (this.currentStepIndex >= sequence.getSteps().size()) {
            this.isReturning = true;
            this.isMoving = true;
            this.currentStepProgress = 0;
            if (ModConfig.debugMode) {
                LOGGER.info("Completed all steps, now returning to original position {}", (Object)blockEntity.getOriginalPos());
            }
            return;
        }
        if (sequence.getSteps().isEmpty()) {
            if (ModConfig.debugMode) {
                LOGGER.info("No steps to execute");
            }
            return;
        }
        if (this.currentStepIndex < 0 || this.currentStepIndex >= sequence.getSteps().size()) {
            LOGGER.error("Step index {} is out of bounds for sequence with {} steps", (Object)this.currentStepIndex, (Object)sequence.getSteps().size());
            this.currentStepIndex = 0;
            if (sequence.getSteps().isEmpty()) {
                return;
            }
        }
        MovementStep step = sequence.getSteps().get(this.currentStepIndex);
        if (!this.isMoving) {
            this.isMoving = true;
            this.currentStepProgress = 0;
            if (ModConfig.debugMode) {
                LOGGER.info("Starting movement step {}: {} blocks in direction {} at speed {} ticks/block", new Object[]{this.currentStepIndex, step.getDistance(), step.getDirection(), step.getSpeed()});
            }
        }
    }

    private void continueCurrentStep(Level level, BlockState state, ParkourBlockEntity blockEntity, MovementSequence sequence) {
        MovementStep step;
        if (this.isReturning) {
            BlockPos originalPos = blockEntity.getOriginalPos();
            Direction direction = this.getDirectionTowards(this.currentPos, originalPos);
            int speed = blockEntity.getMovementSpeed();
            step = new MovementStep(direction, 1, speed);
            if (ModConfig.debugMode) {
                LOGGER.info("Using return step: {} towards original position {} at speed {} ticks/block", new Object[]{direction.m_122433_(), originalPos, speed});
            }
        } else {
            if (this.currentStepIndex < 0 || this.currentStepIndex >= sequence.getSteps().size()) {
                LOGGER.error("Step index {} is out of bounds for sequence with {} steps", (Object)this.currentStepIndex, (Object)sequence.getSteps().size());
                this.currentStepIndex = 0;
                this.isMoving = false;
                return;
            }
            step = sequence.getSteps().get(this.currentStepIndex);
        }
        if (this.tickCounter % step.getSpeed() == 0) {
            boolean canMove;
            Direction direction = step.getDirection();
            BlockPos newPos = this.currentPos.m_121945_(direction);
            boolean bl = canMove = level.m_8055_(newPos).m_60795_() || blockEntity.canDestroyBlocks();
            if (canMove) {
                BlockPos origPos;
                ParkourBlockEntity parkourBlockEntity;
                List<Entity> entitiesOnBlock;
                MovementSequence currentSequence = blockEntity.getMovementSequence();
                boolean movementEnabled = blockEntity.isMovementEnabled();
                boolean destroyBlocks = blockEntity.canDestroyBlocks();
                boolean isBlocked = blockEntity.isBlocked();
                BlockPos originalPos = blockEntity.getOriginalPos();
                List<MobEffectInstance> effects = blockEntity.getEffects();
                if (ModConfig.debugMode) {
                    LOGGER.info("Saving block entity data before move: {} steps, movement {}, destroyBlocks {}", new Object[]{currentSequence.getSteps().size(), movementEnabled ? "enabled" : "disabled", destroyBlocks ? "enabled" : "disabled"});
                    LOGGER.info("Effects count: {}", (Object)effects.size());
                    LOGGER.info("Original position: {}", (Object)originalPos);
                }
                if (!level.m_8055_(newPos).m_60795_() && destroyBlocks) {
                    if (ModConfig.debugMode) {
                        LOGGER.info("Destroying block at {} to make way for movement", (Object)newPos);
                    }
                    level.m_46961_(newPos, true);
                }
                if (!(entitiesOnBlock = this.findEntitiesOnBlock(level, this.currentPos)).isEmpty() && ModConfig.debugMode) {
                    LOGGER.info("Found {} entities on block at {}", (Object)entitiesOnBlock.size(), (Object)this.currentPos);
                }
                BlockState disguiseState = null;
                if (blockEntity instanceof ParkourBlockEntity && (disguiseState = (parkourBlockEntity = blockEntity).getDisguiseState()) != null && ModConfig.debugMode) {
                    LOGGER.info("Saved disguise state: {} with properties: {}", (Object)disguiseState.m_60734_().m_49954_().getString(), (Object)disguiseState.m_61148_());
                }
                this.savedSequence = currentSequence;
                this.savedMovementEnabled = movementEnabled;
                this.savedDestroyBlocks = destroyBlocks;
                this.savedEffects = effects;
                this.savedOriginalPos = originalPos;
                this.savedDisguiseState = disguiseState;
                this.lastBlockPos = this.currentPos.m_7949_();
                this.targetBlockPos = newPos.m_7949_();
                boolean isDisguised = (Boolean)state.m_61143_((Property)ParkourBlock.DISGUISED);
                BlockState newBlockState = state;
                if (isDisguised) {
                    ParkourBlock.DisguiseType disguiseType = (ParkourBlock.DisguiseType)((Object)state.m_61143_(ParkourBlock.DISGUISE_TYPE));
                    newBlockState = (BlockState)((BlockState)state.m_61124_((Property)ParkourBlock.DISGUISED, (Comparable)Boolean.TRUE)).m_61124_(ParkourBlock.DISGUISE_TYPE, (Comparable)((Object)disguiseType));
                    if (ModConfig.debugMode) {
                        LOGGER.info("Setting disguised state for new block at {} with disguise type {}", (Object)newPos, (Object)disguiseType);
                    }
                }
                level.m_7471_(this.currentPos, false);
                level.m_7731_(newPos, newBlockState, 3);
                level.m_7260_(newPos, state, newBlockState, 3);
                level.m_46745_(newPos).m_8092_(true);
                if (ModConfig.debugMode) {
                    LOGGER.info("Set block at {} with state {}", (Object)newPos, (Object)newBlockState);
                }
                for (Entity entity : entitiesOnBlock) {
                    this.entitiesOnBlocks.put(entity, newPos);
                    if (!ModConfig.debugMode) continue;
                    LOGGER.info("Registered entity {} to move with block to {}", (Object)entity.m_7755_().getString(), (Object)newPos);
                }
                BlockEntity newBlockEntity = level.m_7702_(newPos);
                if (newBlockEntity instanceof ParkourBlockEntity) {
                    ParkourBlockEntity newParkourBlockEntity = (ParkourBlockEntity)newBlockEntity;
                    newParkourBlockEntity.setMovementSequence(currentSequence);
                    newParkourBlockEntity.setMovementEnabled(movementEnabled);
                    newParkourBlockEntity.setDestroyBlocks(destroyBlocks);
                    newParkourBlockEntity.setBlocked(false);
                    newParkourBlockEntity.setEffects(effects);
                    newParkourBlockEntity.setOriginalPos(originalPos);
                    BlockState currentState = level.m_8055_(newPos);
                    boolean isAlreadyDisguised = currentState.m_61138_((Property)ParkourBlock.DISGUISED) && (Boolean)currentState.m_61143_((Property)ParkourBlock.DISGUISED) != false;
                    ParkourBlock.DisguiseType disguiseType = null;
                    if (currentState.m_61138_(ParkourBlock.DISGUISE_TYPE)) {
                        disguiseType = (ParkourBlock.DisguiseType)((Object)currentState.m_61143_(ParkourBlock.DISGUISE_TYPE));
                    }
                    if (ModConfig.debugMode) {
                        LOGGER.info("Current block state at {}: {}", (Object)newPos, (Object)currentState);
                        LOGGER.info("Is already disguised: {}, Disguise type: {}", (Object)isAlreadyDisguised, (Object)disguiseType);
                    }
                    if (this.savedDisguiseState != null) {
                        BlockState newState;
                        BlockState disguiseStateCopy = this.savedDisguiseState;
                        if (ModConfig.debugMode) {
                            LOGGER.info("Transferring disguise state: {} with properties: {}", (Object)disguiseStateCopy.m_60734_().m_49954_().getString(), (Object)disguiseStateCopy.m_61148_());
                        }
                        newParkourBlockEntity.setDisguiseState(disguiseStateCopy);
                        if (currentState.m_61138_((Property)ParkourBlock.DISGUISED)) {
                            BlockState tempState = (BlockState)currentState.m_61124_((Property)ParkourBlock.DISGUISED, (Comparable)Boolean.TRUE);
                            if (currentState.m_61138_(ParkourBlock.DISGUISE_TYPE)) {
                                ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)disguiseStateCopy.m_60734_());
                                String blockIdString = blockId.toString();
                                ParkourBlock.DisguiseType newDisguiseType = ParkourBlock.DisguiseType.fromBlockId(blockIdString);
                                tempState = (BlockState)tempState.m_61124_(ParkourBlock.DISGUISE_TYPE, (Comparable)((Object)newDisguiseType));
                            }
                            newState = tempState;
                            level.m_7731_(newPos, newState, 3);
                            level.m_7260_(newPos, currentState, newState, 3);
                            level.m_46745_(newPos).m_8092_(true);
                            if (ModConfig.debugMode) {
                                LOGGER.info("Updated block state at {} to {}", (Object)newPos, (Object)newState);
                            }
                        } else {
                            newState = currentState;
                            if (ModConfig.debugMode) {
                                LOGGER.warn("Block at {} does not have DISGUISED property: {}", (Object)newPos, (Object)currentState);
                            }
                        }
                        level.m_186460_(newPos, currentState.m_60734_(), 1);
                        BlockPos finalNewPos = newPos.m_7949_();
                        BlockState finalNewState = newState;
                        level.m_7654_().execute(() -> {
                            BlockEntity updatedEntity = level.m_7702_(finalNewPos);
                            if (updatedEntity instanceof ParkourBlockEntity) {
                                ParkourBlockEntity updatedParkourEntity = (ParkourBlockEntity)updatedEntity;
                                updatedParkourEntity.setDisguiseState(disguiseStateCopy);
                                updatedParkourEntity.m_6596_();
                                level.m_7260_(finalNewPos, finalNewState, finalNewState, 3);
                                if (ModConfig.debugMode) {
                                    LOGGER.info("Applied disguise state again in server thread");
                                }
                            }
                        });
                        if (ModConfig.debugMode) {
                            LOGGER.info("Transferred disguise state to block at {}", (Object)newPos);
                        }
                    }
                    newParkourBlockEntity.m_6596_();
                    if (ModConfig.debugMode) {
                        LOGGER.info("Transferred data to new block entity at {}", (Object)newPos);
                    }
                }
                this.currentPos = newPos.m_7949_();
                ++this.currentStepProgress;
                if (ModConfig.debugMode) {
                    LOGGER.info("Moved block to {}, progress {}/{}", new Object[]{newPos, this.currentStepProgress, step.getDistance()});
                }
                if (this.isReturning && newPos.equals((Object)(origPos = blockEntity.getOriginalPos()))) {
                    this.isReturning = false;
                    this.currentStepIndex = 0;
                    this.isMoving = false;
                    this.currentStepProgress = 0;
                    if (ModConfig.debugMode) {
                        LOGGER.info("Returned to original position {}, ready to start sequence again", (Object)origPos);
                    }
                }
                if (this.currentStepProgress >= step.getDistance()) {
                    ++this.currentStepIndex;
                    this.isMoving = false;
                    if (ModConfig.debugMode) {
                        LOGGER.info("Completed movement step {}", (Object)(this.currentStepIndex - 1));
                    }
                }
            } else {
                if (ModConfig.debugMode) {
                    LOGGER.info("Movement blocked at {}, stopping", (Object)newPos);
                }
                this.isMoving = false;
                blockEntity.setBlocked(true);
            }
        }
    }

    private Direction getDirectionTowards(BlockPos from, BlockPos to) {
        int dx = to.m_123341_() - from.m_123341_();
        int dy = to.m_123342_() - from.m_123342_();
        int dz = to.m_123343_() - from.m_123343_();
        int absDx = Math.abs(dx);
        int absDy = Math.abs(dy);
        int absDz = Math.abs(dz);
        if (absDx >= absDy && absDx >= absDz && absDx > 0) {
            return dx > 0 ? Direction.EAST : Direction.WEST;
        }
        if (absDy >= absDx && absDy >= absDz && absDy > 0) {
            return dy > 0 ? Direction.UP : Direction.DOWN;
        }
        if (absDz >= absDx && absDz >= absDy && absDz > 0) {
            return dz > 0 ? Direction.SOUTH : Direction.NORTH;
        }
        if (ModConfig.debugMode) {
            LOGGER.info("Positions are the same or very close: from={}, to={}", (Object)from, (Object)to);
        }
        return Direction.UP;
    }

    private List<Entity> findEntitiesOnBlock(Level level, BlockPos pos) {
        AABB boundingBox = new AABB((double)pos.m_123341_(), (double)pos.m_123342_() + 0.8, (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)pos.m_123342_() + 1.5, (double)(pos.m_123343_() + 1));
        List entities = level.m_45976_(Entity.class, boundingBox);
        if (ModConfig.debugMode && !entities.isEmpty()) {
            LOGGER.info("Found {} entities on block at {}: {}", new Object[]{entities.size(), pos, entities.stream().map(e -> e.m_7755_().getString()).collect(Collectors.joining(", "))});
        }
        return entities;
    }

    private void updateEntitiesOnBlocks(Level level) {
        if (this.targetBlockPos == null || this.lastBlockPos == null || this.entitiesOnBlocks.isEmpty()) {
            return;
        }
        for (Map.Entry<Entity, BlockPos> entry : new HashMap<Entity, BlockPos>(this.entitiesOnBlocks).entrySet()) {
            Entity entity = entry.getKey();
            BlockPos targetPos = entry.getValue();
            if (!entity.m_6084_()) {
                this.entitiesOnBlocks.remove(entity);
                continue;
            }
            double dx = targetPos.m_123341_() - this.lastBlockPos.m_123341_();
            double dy = targetPos.m_123342_() - this.lastBlockPos.m_123342_();
            double dz = targetPos.m_123343_() - this.lastBlockPos.m_123343_();
            entity.m_6021_(entity.m_20185_() + dx, entity.m_20186_() + dy, entity.m_20189_() + dz);
            entity.m_20334_(0.0, 0.0, 0.0);
            entity.f_19789_ = 0.0f;
            if (!ModConfig.debugMode) continue;
            LOGGER.info("Moved entity {} with block from {} to {}", new Object[]{entity.m_7755_().getString(), this.lastBlockPos, targetPos});
        }
        this.entitiesOnBlocks.clear();
        this.lastBlockPos = null;
        this.targetBlockPos = null;
    }

    public MovementSequence getSavedSequence() {
        return this.savedSequence;
    }

    public boolean isSavedMovementEnabled() {
        return this.savedMovementEnabled;
    }

    public boolean isSavedDestroyBlocks() {
        return this.savedDestroyBlocks;
    }

    public List<MobEffectInstance> getSavedEffects() {
        return this.savedEffects;
    }

    public BlockPos getSavedOriginalPos() {
        return this.savedOriginalPos;
    }

    public BlockState getSavedDisguiseState() {
        return this.savedDisguiseState;
    }
}

