/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.client.gui.widget;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class ModernButton
extends Button {
    private static final int CORNER_RADIUS = 4;
    private static final int ANIMATION_DURATION = 150;
    private float hoverProgress = 0.0f;
    private long lastUpdateTime = System.currentTimeMillis();
    private final int baseColor;
    private final int hoverColor;
    private final int pressedColor;
    private final int disabledColor;
    private final int textColor;
    private final int disabledTextColor;

    protected ModernButton(int x, int y, int width, int height, Component message, Button.OnPress onPress, Button.CreateNarration createNarration, int baseColor, int hoverColor, int pressedColor, int disabledColor, int textColor, int disabledTextColor) {
        super(x, y, width, height, message, onPress, createNarration);
        this.baseColor = baseColor;
        this.hoverColor = hoverColor;
        this.pressedColor = pressedColor;
        this.disabledColor = disabledColor;
        this.textColor = textColor;
        this.disabledTextColor = disabledTextColor;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int buttonColor;
        long currentTime = System.currentTimeMillis();
        float deltaTime = (float)(currentTime - this.lastUpdateTime) / 1000.0f;
        this.lastUpdateTime = currentTime;
        boolean isHovered = this.m_274382_();
        float targetProgress = isHovered ? 1.0f : 0.0f;
        float animationSpeed = 6.6666665f;
        if (this.hoverProgress < targetProgress) {
            this.hoverProgress = Math.min(targetProgress, this.hoverProgress + animationSpeed * deltaTime);
        } else if (this.hoverProgress > targetProgress) {
            this.hoverProgress = Math.max(targetProgress, this.hoverProgress - animationSpeed * deltaTime);
        }
        if (!this.f_93623_) {
            buttonColor = this.disabledColor;
        } else if (this.m_198029_()) {
            buttonColor = this.lerpColor(this.baseColor, this.m_198029_() && !this.m_274382_() ? this.hoverColor : (this.m_274382_() ? this.hoverColor : this.baseColor), this.hoverProgress);
            if (this.m_274382_() && mouseX >= this.m_252754_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY >= this.m_252907_() && mouseY < this.m_252907_() + this.f_93619_) {
                buttonColor = this.pressedColor;
            }
        } else {
            buttonColor = this.lerpColor(this.baseColor, this.hoverColor, this.hoverProgress);
        }
        this.drawRoundedRect(guiGraphics, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 4, buttonColor);
        int borderColor = !this.f_93623_ ? -2139062144 : (this.m_198029_() ? -1 : -1056964609);
        this.drawRoundedRectBorder(guiGraphics, this.m_252754_(), this.m_252907_(), this.f_93618_, this.f_93619_, 4, borderColor, 2);
        int textColorToUse = this.f_93623_ ? this.textColor : this.disabledTextColor;
        guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, textColorToUse);
    }

    private void drawRoundedRect(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        guiGraphics.m_280509_(x + radius, y, x + width - radius, y + height, color);
        guiGraphics.m_280509_(x, y + radius, x + radius, y + height - radius, color);
        guiGraphics.m_280509_(x + width - radius, y + radius, x + width, y + height - radius, color);
        guiGraphics.m_280509_(x, y, x + radius, y + radius, color);
        guiGraphics.m_280509_(x + width - radius, y, x + width, y + radius, color);
        guiGraphics.m_280509_(x, y + height - radius, x + radius, y + height, color);
        guiGraphics.m_280509_(x + width - radius, y + height - radius, x + width, y + height, color);
    }

    private void drawRoundedRectBorder(GuiGraphics guiGraphics, int x, int y, int width, int height, int radius, int color, int thickness) {
        guiGraphics.m_280509_(x + radius, y, x + width - radius, y + thickness, color);
        guiGraphics.m_280509_(x + radius, y + height - thickness, x + width - radius, y + height, color);
        guiGraphics.m_280509_(x, y + radius, x + thickness, y + height - radius, color);
        guiGraphics.m_280509_(x + width - thickness, y + radius, x + width, y + height - radius, color);
    }

    private int lerpColor(int color1, int color2, float t) {
        t = Mth.m_14036_((float)t, (float)0.0f, (float)1.0f);
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static class Builder {
        private final Component message;
        private final Button.OnPress onPress;
        private int x;
        private int y;
        private int width = 200;
        private int height = 20;
        private int baseColor = -12877066;
        private int hoverColor = -14326805;
        private int pressedColor = -14856488;
        private int disabledColor = -6511697;
        private int textColor = -1;
        private int disabledTextColor = -3025445;

        public Builder(Component message, Button.OnPress onPress) {
            this.message = message;
            this.onPress = onPress;
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder baseColor(int color) {
            this.baseColor = color;
            return this;
        }

        public Builder hoverColor(int color) {
            this.hoverColor = color;
            return this;
        }

        public Builder pressedColor(int color) {
            this.pressedColor = color;
            return this;
        }

        public Builder disabledColor(int color) {
            this.disabledColor = color;
            return this;
        }

        public Builder textColor(int color) {
            this.textColor = color;
            return this;
        }

        public Builder disabledTextColor(int color) {
            this.disabledTextColor = color;
            return this;
        }

        public Builder greenScheme() {
            this.baseColor = -15681151;
            this.hoverColor = -16411031;
            this.pressedColor = -16484265;
            return this;
        }

        public Builder redScheme() {
            this.baseColor = -1096636;
            this.hoverColor = -2349530;
            this.pressedColor = -4645860;
            return this;
        }

        public Builder grayScheme() {
            this.baseColor = -9735552;
            this.hoverColor = -11840157;
            this.pressedColor = -13156015;
            return this;
        }

        public Builder purpleScheme() {
            this.baseColor = -7643914;
            this.hoverColor = -8635667;
            this.pressedColor = -9623335;
            return this;
        }

        public ModernButton build() {
            return new ModernButton(this.x, this.y, this.width, this.height, this.message, this.onPress, f_252438_, this.baseColor, this.hoverColor, this.pressedColor, this.disabledColor, this.textColor, this.disabledTextColor);
        }
    }
}

