/*
 * Decompiled with CFR 0.152.
 */
package de.sarocesch.pakourblocks.client.model;

import com.mojang.logging.LogUtils;
import de.sarocesch.pakourblocks.client.model.ParkourBlockBakedModel;
import java.util.Map;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="saroparkourblocks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModelEventHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String MODID = "saroparkourblocks";

    @SubscribeEvent
    public static void onModifyBakingResult(ModelEvent.ModifyBakingResult event) {
        ModelResourceLocation parkourBlockLocation;
        Map modelRegistry = event.getModels();
        BakedModel originalModel = (BakedModel)modelRegistry.get(parkourBlockLocation = new ModelResourceLocation(new ResourceLocation(MODID, "parkour_block"), "blocked=false,disguise_type=stone,disguised=false"));
        if (originalModel != null) {
            ParkourBlockBakedModel customModel = new ParkourBlockBakedModel(originalModel);
            modelRegistry.put(parkourBlockLocation, customModel);
            LOGGER.info("Replaced parkour block model with custom BakedModel");
            for (Map.Entry entry : modelRegistry.entrySet()) {
                ModelResourceLocation modelResLoc;
                ResourceLocation location = (ResourceLocation)entry.getKey();
                if (!(location instanceof ModelResourceLocation) || !(modelResLoc = (ModelResourceLocation)location).m_135827_().equals(MODID) || !modelResLoc.m_135815_().equals("parkour_block")) continue;
                BakedModel variantOriginal = (BakedModel)entry.getValue();
                ParkourBlockBakedModel variantCustom = new ParkourBlockBakedModel(variantOriginal);
                modelRegistry.put(location, variantCustom);
                LOGGER.info("Replaced parkour block variant {} with custom BakedModel", (Object)modelResLoc.m_119448_());
            }
        } else {
            LOGGER.warn("Could not find original parkour block model to replace!");
        }
    }
}

